#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>

#include <qcursor.h>

#include "tulip/SuperGraph.h"
#include "tulip/MouseObject.h"
#include "tulip/GlGraphWidget.h"
#include "tulip/TulipElementProperties.h"

using namespace tlp;
// according to Qt's doc, this constant has been defined by wheel mouse vendors
// we need it to interpret the value of QWheelEvent->delta()
#define WHEEL_DELTA 120

//===============================================================
void MouseMove::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (qMouseEv->button()==QEvent::LeftButton) {
    x=qMouseEv->x();
    y=qMouseEv->y();
  }
  if (qMouseEv->button()==QEvent::MidButton) {}
}
void MouseMove::mPaint(GlGraphWidget *){}
void MouseMove::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {}
void MouseMove::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (qMouseEv->x()!=x) glGraphWidget->getGlGraph()->translateCamera(qMouseEv->x()-x,0,0);
  if (qMouseEv->y()!=y) glGraphWidget->getGlGraph()->translateCamera(0,y-qMouseEv->y(),0);
  x=qMouseEv->x();
  y=qMouseEv->y();
}
//===============================================================
void MouseRotXRotY::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==QEvent::LeftButton) {
    y=qMouseEv->y();
    x=qMouseEv->x();
  }
  if (qMouseEv->button()==QEvent::MidButton) {}
}
void MouseRotXRotY::mPaint(GlGraphWidget *){}
void MouseRotXRotY:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {}
void MouseRotXRotY:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  int deltaX,deltaY;
  deltaX=qMouseEv->x()-x;
  deltaY=qMouseEv->y()-y;
  if (abs(deltaX)>abs(deltaY)) 
    deltaY=0;
  else
    deltaX=0;  
  if (deltaY!=0) glGraphWidget->getGlGraph()->rotateScene(deltaY,0,0);
  if (deltaX!=0) glGraphWidget->getGlGraph()->rotateScene(0,deltaX,0);
  x=qMouseEv->x();
  y=qMouseEv->y();
}
//===============================================================
void MouseZoomRotZ::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==QEvent::LeftButton) {
    y=qMouseEv->y();
    x=qMouseEv->x();
  }
  if (qMouseEv->button()==QEvent::MidButton) {}
}
void MouseZoomRotZ::mPaint(GlGraphWidget *){}
void MouseZoomRotZ:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{}
void MouseZoomRotZ:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  int deltaX,deltaY;
  deltaX=qMouseEv->x()-x;
  deltaY=qMouseEv->y()-y;
  if (abs(deltaX)>abs(deltaY)) 
    deltaY=0;
  else
    deltaX=0; 
  if (deltaX!=0) glGraphWidget->getGlGraph()->rotateScene(0,0,deltaX);
  if (deltaY!=0) glGraphWidget->getGlGraph()->zoom(-deltaY);
  x=qMouseEv->x();
  y=qMouseEv->y();
}
//===============================================================
// Fonstion de souris appartenant  l'application
//===============================================================
void MouseSelect::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==QEvent::LeftButton) {
    glGraphWidget->clickAt(qMouseEv->pos());
  }
  if (qMouseEv->button()==QEvent::MidButton){}
}
void MouseSelect::mPaint(GlGraphWidget *){}
void MouseSelect::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
void MouseSelect::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
//===============================================================
void MouseDel::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (qMouseEv->button()==QEvent::LeftButton) {
      glGraphWidget->deleteElement(qMouseEv->x(),qMouseEv->y());
    }
  if (qMouseEv->button()==QEvent::MidButton)
  {}
  if (qMouseEv->button()==QEvent::RightButton)
    {}
}
void MouseDel::mPaint(GlGraphWidget *){}
void MouseDel::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{}
void MouseDel::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{}
//===============================================================
void MouseDelSelection::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{
  if (qMouseEv->button()==QEvent::LeftButton) {
      glGraphWidget->delSelection();
    }
  if (qMouseEv->button()==QEvent::MidButton) {}
  if (qMouseEv->button()==QEvent::RightButton) {}
}
void MouseDelSelection::mPaint(GlGraphWidget *){}
void MouseDelSelection::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
void MouseDelSelection::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}

//===============================================================
MouseGraphNavigate::MouseGraphNavigate() : currentMouse(NULL){};
MouseGraphNavigate::~MouseGraphNavigate() {}

void MouseGraphNavigate::mPressEvent(GlGraphWidget *graph, QMouseEvent *e) {
  if (e->button() == QEvent::LeftButton) {
    if (e->state() & QEvent::ControlButton)
      currentMouse = &mouseZoomRotZ;
    else if (e->state() & QEvent::ShiftButton)
      currentMouse = &mouseMove;
    else
      currentMouse = &mouseRotXRotY;
    
    currentMouse->mPressEvent(graph, e);
  }
  else {
    currentMouse = NULL;
    e->ignore();
  }
}

void MouseGraphNavigate::mReleaseEvent(GlGraphWidget *graph, QMouseEvent *e) {}

void MouseGraphNavigate::mMoveEvent(GlGraphWidget *graph, QMouseEvent *e) {
  if ((e->state() & QEvent::LeftButton) && (currentMouse != NULL)) {
    currentMouse->mMoveEvent(graph, e);
  }
  else
    e->ignore();
}

void MouseGraphNavigate::mPaint(GlGraphWidget *) {}

void MouseGraphNavigate::keyPressEvent(GlGraphWidget *g, QKeyEvent *e) {
  int delta = (e->isAutoRepeat() ? 3 : 1);
  e->accept();
  switch(e->key()) {
    case QEvent::Key_Left: g->getGlGraph()->translateCamera(delta * 2,0,0); break;
    case QEvent::Key_Right: g->getGlGraph()->translateCamera(-1 * delta * 2,0,0); break;
    case QEvent::Key_Up: g->getGlGraph()->translateCamera(0,-1 * delta * 2,0); break;
    case QEvent::Key_Down: g->getGlGraph()->translateCamera(0,delta * 2,0); break;
    case QEvent::Key_Prior: g->getGlGraph()->zoom(delta); break;
    case QEvent::Key_Next: g->getGlGraph()->zoom(-1 * delta); break;
    case QEvent::Key_Home: g->getGlGraph()->translateCamera(0,0,-1 * delta * 2); break;
    case QEvent::Key_End: g->getGlGraph()->translateCamera(0,0,delta * 2); break;
    case QEvent::Key_Insert: g->getGlGraph()->rotateScene(0,0,-1 * delta * 2); break;
    case QEvent::Key_Delete : g->getGlGraph()->rotateScene(0,0,delta * 2); break;
    default:
      e->ignore();
    }
}
  
void MouseGraphNavigate::keyReleaseEvent(GlGraphWidget *g, QKeyEvent *e) {
  switch(e->key()) {
  case QEvent::Key_Left:
  case QEvent::Key_Right:
  case QEvent::Key_Up:
  case QEvent::Key_Down:
  case QEvent::Key_Prior:
  case QEvent::Key_Next:
  case QEvent::Key_Home:
  case QEvent::Key_End:
  case QEvent::Key_Insert:
  case QEvent::Key_Delete: break;
  default:
    e->ignore();
  }
}

void MouseGraphNavigate::wheelEvent(GlGraphWidget *g, QWheelEvent *e) {
  if (e->orientation() == QEvent::Vertical) {
    g->getGlGraph()->zoomXY(e->delta() / WHEEL_DELTA, e->x(), e->y());
  }
  else {
    e->ignore();
  }
}

//================================================================================
using namespace std;
Mouse2D::Mouse2D() : currentMouse(NULL) {}

Mouse2D::~Mouse2D() {}

void Mouse2D::mPressEvent(GlGraphWidget *g, QMouseEvent *e) {
  if (e->button() == QEvent::LeftButton) {
    if (e->state() & QEvent::ControlButton) 
      currentMouse = &mouseMove;
    else 
      currentMouse = &mouseSelect;
    currentMouse->mPressEvent(g, e);
  }
  else {
    currentMouse = NULL;
    e->ignore();
  }
}

void Mouse2D::mReleaseEvent(GlGraphWidget *g, QMouseEvent *e) {}

void Mouse2D::mMoveEvent(GlGraphWidget *g, QMouseEvent *e) {
  if ((e->state() & QEvent::LeftButton) && (currentMouse != NULL)) {
    currentMouse->mMoveEvent(g, e);
  }
  else
    e->ignore();
}

void Mouse2D::mPaint(GlGraphWidget *g) {
  if (currentMouse != NULL) currentMouse->mPaint(g);
}

void Mouse2D::keyPressEvent (GlGraphWidget *g, QKeyEvent *e) {
  //  cerr << __PRETTY_FUNCTION__ << ": key=" << e->key() << ", state=" << e->state() << endl;
  if (e->key() & Qt::Key_Control) {
    oldCursor = QCursor(g->cursor());
    g->unsetCursor();
    g->setCursor(QCursor(Qt::SizeAllCursor));
  }

  int delta = (e->isAutoRepeat() ? 3 : 1);
  e->accept();
  switch(e->key()) {
    case QEvent::Key_Left: g->getGlGraph()->translateCamera(delta * 2,0,0); break;
    case QEvent::Key_Right: g->getGlGraph()->translateCamera(-1 * delta * 2,0,0); break;
    case QEvent::Key_Up: g->getGlGraph()->translateCamera(0,-1 * delta * 2,0); break;
    case QEvent::Key_Down: g->getGlGraph()->translateCamera(0,delta * 2,0); break;
    case QEvent::Key_Prior: g->getGlGraph()->zoom(delta); break;
    case QEvent::Key_Next: g->getGlGraph()->zoom(-1 * delta); break;
    case QEvent::Key_Home: g->getGlGraph()->translateCamera(0,0,-1 * delta * 2); break;
    case QEvent::Key_End: g->getGlGraph()->translateCamera(0,0,delta * 2); break;
    case QEvent::Key_Insert: g->getGlGraph()->rotateScene(0,0,-1 * delta * 2); break;
    case QEvent::Key_Delete : g->getGlGraph()->rotateScene(0,0,delta * 2); break;
    default:
      e->ignore();
    }


}
void Mouse2D::keyReleaseEvent(GlGraphWidget *g, QKeyEvent *e) {
  //  cerr << __PRETTY_FUNCTION__ << ": key=" << e->key() << ", state=" << e->state() << endl;  
  if (e->key() & Qt::Key_Control) {
    g->unsetCursor();
    g->setCursor(oldCursor);
  }
}

void Mouse2D::wheelEvent(GlGraphWidget *g, QWheelEvent *e) {
  if (e->orientation() == QEvent::Vertical) {
    g->getGlGraph()->zoomXY(e->delta() / WHEEL_DELTA, e->x(), e->y());
  }
  else {
    e->ignore();
  }
}
