//-*-c++-*-
#ifndef TULIP_LAYOUTPROXY_H
#define TULIP_LAYOUTPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;
class SuperGraph;

/** \addtogroup properties */ 
/*@{*/
class LayoutProxy:public PropertyProxy<PointType,LineType> {
  friend class Layout;

public:
  LayoutProxy (SuperGraph *);
  LayoutProxy ();
  ~LayoutProxy();

  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );

  //=======================================
  //Functions for extra layout information
  Coord getMax(SuperGraph *sg=0);
  Coord getMin(SuperGraph *sg=0);

  //============================================
  //Functions for layout modification
  void center();
  void normalize() _DEPRECATED;
  void perfectAspectRatio();
  void reset_handler();
  void recompute_handler();
  void resetBoundingBox();
  void clone_handler(PropertyProxy<PointType,LineType> &);
  
  virtual void setNodeValue_handler(const node n);
  virtual void setEdgeValue_handler(const edge e);
  virtual void setAllNodeValue_handler();
  virtual void setAllEdgeValue_handler();

  //==============================================================
  // Set of function in order to measure the quality of the Layout
  //==============================================================
  /**
   * Return the lenght of an edge, the bends are taken into account.
   * Thus, it measure the length of a polyline. Warning this function 
   * only measure the length of the polyline between bends, when using
   * curves like bezier etc... the result will not be the length of the curve.
   */
  double edgeLength(edge e);
  /*
   * Return the average angular resolution of the layout
   * it is defined for 2D drawing, the third coordinates
   * is omitted
   */
  double averageAngularResolution(SuperGraph *sg=0);
  /*
   * Return the average angular resolution of a node
   * it is defined for 2D drawing, the third coordinates
   * is omitted
   */
  double averageAngularResolution(const node n,SuperGraph *sg=0);
  /*
   * Return a vector of all angular resolution of a node
   * it is defined for 2D drawing, the third coordinates
   * is omitted
   */
  std::vector<double> angularResolutions(const node n, SuperGraph *sg=0);
  /*
   * Return the number of crossings in the layout
   */
  unsigned int crossingNumber();

private:
  stdext::hash_map<int,Coord> max,min;
  stdext::hash_map<int,bool> minMaxOk;
  void computeMinMax(SuperGraph * sg=NULL);
};
/*@}*/
#endif










