//-*-c++-*-
#ifndef TULIP_SIZESPROXY_H
#define TULIP_SIZESPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;
/**
 * \defgroup properties
 */ 
/*@{*/
class SizesProxy:public PropertyProxy<SizeType,SizeType> { 

  friend class Sizes;

public :
  SizesProxy (SuperGraph *);
  ~SizesProxy();
  void reset_handler();
  void recompute_handler();
  Size getMax(SuperGraph *sg=0);
  Size getMin(SuperGraph *sg=0);
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );

protected:
  void resetMinMax();
  virtual void setNodeValue_handler(const node n);
  virtual void setEdgeValue_handler(const edge e);
  virtual void setAllNodeValue_handler();
  virtual void setAllEdgeValue_handler();

private:
  stdext::hash_map<int,Size> max,min;
  stdext::hash_map<int,bool> minMaxOk;
  void computeMinMax(SuperGraph * sg=NULL);
};
/*@}*/
#endif

