template <typename Obj,unsigned int SIZE>
Obj tlp::Array<Obj,SIZE>::operator[](const unsigned int i) const {
  assert(i<SIZE);
  return array[i];
}
template <typename Obj,unsigned int SIZE>
Obj& tlp::Array<Obj,SIZE>::operator[](const unsigned int i) {
  assert(i<SIZE);
  return array[i];
}

template <typename Obj,unsigned int SIZE>
std::ostream& tlp::operator<<(std::ostream &os,const tlp::Array<Obj,SIZE> &a) {
  os << "(" ;
  for ( uint i=0 ; i<SIZE ; ++i ) {
  	if( i>0 )
	  	os << ",";
    if( typeid(Obj) == typeid(char) )
    	os << int(a[i]);
    else if( typeid(Obj) == typeid(unsigned char) )
    	os << (unsigned int)a[i];
    else
    	os << a[i];
  }
  os << ")" ;
  return os;
}

template <typename Obj,unsigned int SIZE>
std::istream & tlp::operator>> (std::istream &is, tlp::Array<Obj,SIZE> & outA) {
  char c;
  int pos = is.tellg();
  is.clear();

  if( !(is >> c) || c!='(' ) {
	  is.seekg(pos);
	  is.setstate( std::ios::failbit );
	  return is;  
  }

  for( unsigned int i=0;i<SIZE;++i ) {
	  if( i>0 && ( !(is >> c) || c!=',' ) ) {
		  is.seekg(pos);
		  is.setstate( std::ios::failbit );
		  return is;  
	  }

	  bool done = true;

	  if( typeid(Obj) == typeid(char) ) {
	  	int vi;
	  	done = ( is >> vi );
	  	outA.array[i] = vi;
	  } else if( typeid(Obj) == typeid(unsigned char) ) {
	  	unsigned int vi;
	  	done = ( is >> vi );
	  	outA.array[i] = vi;
	  } else {
		done = ( is >> outA.array[i] );
	  }

	  if( !done ) {
	  	  is.seekg(pos);
		  is.setstate( std::ios::failbit );
		  return is;
	  }
  }

  if( !(is >> c) || c!=')' ) {
	  is.seekg(pos);
	  is.setstate( std::ios::failbit );
	  return is;  
  }

  return is;  
}


