#ifndef TULIPCONF_H
#define TULIPCONF_H

#if (__GNUC__ < 3)
#  define stdext std
#  define _DEPRECATED
#  include <stl_hash_fun.h>
#else
#  define stdext __gnu_cxx
#  define _DEPRECATED __attribute__ ((deprecated))
#  include <ext/stl_hash_fun.h>
#endif

#include <string>

namespace stdext {
  template<> struct hash<const std::string>{
    size_t operator()(const std::string &s) const {return hash<const char *>()(s.c_str()); }
  };
  template<> struct hash<std::string>{
    size_t operator()(const std::string &s) const {return hash<const char *>()(s.c_str()); }
  };
}

#endif //TULIPCONF_H
