//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/IntProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Int.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

//==============================
///Constructeur d'un IntProxy
IntProxy::IntProxy (SuperGraph *graph):PropertyProxy<IntType,IntType>(graph) {
  minMaxOk=false;
  //  propertyProxy=this;
}
//==============================
///Destructeur d'un int Proxy  
///Vide pour l'instant, cela peut
///provoquer des fuites m�moires
IntProxy::~IntProxy() {
}    
//====================================================================
///Renvoie le minimum de la m�trique associ� aux noeuds du IntProxy
int IntProxy::getNodeMin() {
  if (!minMaxOk) 
    computeMinMax();
  return minN;
}
//====================================================================
///Renvoie le maximum de la m�trique associ� aux noeuds du IntProxy
int IntProxy::getNodeMax() {
  if (!minMaxOk) 
    computeMinMax();
  return maxN;
}
//====================================================================
///Renvoie le Minimum de la m�trique associ� aux ar�tes du IntProxy
int IntProxy::getEdgeMin() {
  if (!minMaxOk) 
    computeMinMax();
  return minE;
}
//====================================================================
///Renvoie le Maximum de la m�trique associ� aux ar�tes du IntProxy
int IntProxy::getEdgeMax() {
  if (!minMaxOk) 
    computeMinMax();
  return maxE;
}
//========================================================================
///Calcul le min et le Max de la m�trique associ� au proxy
///Attention, la gestion du mim et max des ar�tes n'est pas 
///assur� ici et doit �tre ajout� ult�rieurement
void IntProxy::computeMinMax() {
  //cerr << "Compute Min Max" << endl;
  int tmp;
  Iterator<node> *itN=superGraph->getNodes();
  if (itN->hasNext()) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    maxN=tmp;
    minN=tmp;
  }
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    if (tmp>maxN) maxN=tmp;
    if (tmp<minN) minN=tmp;
  }
  delete itN;
  Iterator<edge> *itE=superGraph->getEdges();
  if (itE->hasNext()) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    maxE=tmp;
    minE=tmp;
  }
  for (;itE->hasNext();) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    if (tmp>maxE) maxE=tmp;
    if (tmp<minE) minE=tmp;
  }
  delete itE;
  minMaxOk=true;
}
//=============================================================================
///Poign� permettnet le reset des variables du IntProxy par le PropertyProxy
void IntProxy::reset_handler() {
  minMaxOk=false;
}
//=============================================================================
///Poign� permettnet le recompute il faut absolument mettre le graphProperties
///currentIntProxy � this sinon le r�sultat est impr�visible
void IntProxy::recompute_handler() {
  //  superGraph->getPropertyManager()->currentPropertyProxy=this;
  minMaxOk=false;
}
//=================================================================================
void IntProxy::clone_handler(PropertyProxy<IntType,IntType> &proxyC) {
  if (typeid(this)==typeid(&proxyC)) {
    IntProxy *proxy=(IntProxy *)&proxyC;
    minMaxOk=proxy->minMaxOk;
    if (minMaxOk) {
      minE=proxy->minE;
      maxE=proxy->maxE;
      minN=proxy->minN;
      maxN=proxy->maxN;
    }
  }
  else{
    minMaxOk=false;
  }
}

//=================================================================================
PProxy* IntProxy::clonePrototype(SuperGraph * g, std::string n)
{
	if( !g )
		return 0;
	IntProxy * p = g->getLocalProperty<IntProxy>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void IntProxy::copy( const node n0, const node n1, PProxy * p )
{
	if( !p )
		return;
	IntProxy * tp = dynamic_cast<IntProxy*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void IntProxy::copy( const edge e0, const edge e1, PProxy * p )
{
	if( !p )
		return;
	IntProxy * tp = dynamic_cast<IntProxy*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}






