#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/SuperGraph.h"

using namespace std;

IdManager SuperGraph::idManager;

ostream & operator << (ostream &os,const SuperGraph *sp) {
  os << ";(nodes <node_id> <node_id> ...)" << endl;
  os << "(nodes ";
  Iterator<node> *itn=sp->getNodes();
  for (;itn->hasNext();) {
    os << itn->next().id;
    if (itn->hasNext()) os << " ";
  } delete itn;
  os << ")" << endl;
  os << ";(edge <edge_id> <source_id> <target_id>)" << endl;
  Iterator<edge> *ite=sp->getEdges();
  for (;ite->hasNext();) {
    edge e=ite->next();
    os << "(edge " << e.id << " " << sp->source(e).id << " " << sp->target(e).id << ")";
    if (ite->hasNext()) os << endl;
  } delete ite;
  os << endl;
  return os;
}




