#include <math.h>
#include <stdio.h>
#include <sstream>
#include <string>
#include <list>
#include <map>
#include <iostream>
#include <tulip/SuperGraph.h>
#include <tulip/SelectionProxy.h>
#include <tulip/MetaGraphProxy.h>
#include <tulip/TlpTools.h>
#include <tulip/GraphMeasure.h>
#include <tulip/StableIterator.h>
#include "StrengthClustering.h"

CLUSTERINGPLUGIN(StrengthClustering,"Strength","David Auber","27/01/2003","Alpha","0","1");

using namespace std;

//================================================================================
StrengthClustering::StrengthClustering(ClusterContext context):Clustering(context) {}
//================================================================================
StrengthClustering::~StrengthClustering() {}
//================================================================================
double StrengthClustering::e(set<node> &U,set<node> &V) {
  set<node>::const_iterator itU;
  double result=0;
  for (itU=U.begin();itU!=U.end();++itU) {
    Iterator<node> *itN=superGraph->getInOutNodes(*itU);
    for (;itN->hasNext();) {
      node itn=itN->next();
      if (V.find(itn)!=V.end()) result+=1;
    }delete itN;
  }
  return result;
}
//==============================================================================
double StrengthClustering::e(set<node> &U) {
  set<node>::const_iterator itU;
  double result=0;
  for (itU=U.begin();itU!=U.end();++itU) {
    Iterator<node> *itN=superGraph->getInOutNodes(*itU);
    for (;itN->hasNext();) {
      node itn=itN->next();
      if (U.find(itn)!=U.end()) result+=1;
    }delete itN;
  }
  return result/2.0;
}
//==============================================================================
double StrengthClustering::s(set<node> &U,set<node> &V) {
  if ((U.size()==0) || (V.size()==0)) return 0;
  return (e(U,V) / double(U.size()*V.size()));
}
//==============================================================================
double StrengthClustering::s(set<node> &U) {
  if (U.size()<2) return 0;
  return  (e(U)) * 2.0 / double(U.size()*(U.size()-1.0));
}
//==============================================================================
double StrengthClustering::computeMQValue(vector<set<node> > partition) {
  double positive=0;
  for (unsigned int i=0;i<partition.size();++i) {
    positive+=s(partition[i]);
  }
  positive/=double(partition.size());
  double negative=0;
  for (unsigned int i=0;i<partition.size()-1;++i)
    for (unsigned int j=i+1;j<partition.size();++j) {
      negative+=s(partition[i],partition[j]);
    }
  if (partition.size()>1)
    negative/=double(partition.size()*(partition.size()-1)/2.0);
  //  cout << "positive :"<< positive << " , negative :" << negative << endl;
  return positive-negative;
}
//==============================================================================
vector< set<node> > StrengthClustering::computeNodePartition(double threshold) {
  cerr << __PRETTY_FUNCTION__ << endl;
  bool cached,results;
  string errMsg;
  //  MetricProxy *values=superGraph->getLocalProperty<MetricProxy>("Strength",cached,results,errMsg);  
  // double threshold=2;
  // step One build a filtered subgraph
  // All edges with a values less than the threshold are removed
  //  cerr << "1" << endl << flush;
  SuperGraph *tmpGraph=tlp::newCloneSubGraph(superGraph);
  StableIterator<edge> itE(superGraph->getEdges());
  while (itE.hasNext()) {
    edge ite=itE.next();
    if (values->getEdgeValue(ite)<threshold) {
      if (superGraph->deg(superGraph->source(ite))>1 && superGraph->deg(superGraph->target(ite))>1)
	tmpGraph->delEdge(ite);
    }
  }
  

  set<node> singleton;
  // Select SubGraph singleton in superGraph
  //  cerr << "2" << endl << flush;
  StableIterator<node> itN(tmpGraph->getNodes());
  while (itN.hasNext()) {
    node itn=itN.next();
    if (tmpGraph->deg(itn)==0) singleton.insert(itn);
  }
  
  // restore edges to reconnect singleton by computing induced subgraph 
  StableIterator<edge> itE2(superGraph->getEdges());
  while (itE2.hasNext()) {
    edge ite=itE2.next();
    if (singleton.find(superGraph->source(ite))!=singleton.end() && singleton.find(superGraph->target(ite))!=singleton.end()) {
      tmpGraph->addEdge(ite);
    }
  }

  //Extract connected componnent
  //  cerr << "5" << endl << flush;
  MetricProxy *connected= new MetricProxy(tmpGraph); 
  tmpGraph->computeProperty("Connected Component", connected, errMsg);

  //Put individual nodes in the same cluster
  double val=-1;
  Iterator<node> *itN2 = tmpGraph->getNodes();
  while (itN2->hasNext()) {
    node itn=itN2->next();
    if (tmpGraph->deg(itn)==0) {
      if (val==-1) val=connected->getNodeValue(itn);
      else
	connected->setNodeValue(itn,val);
    }
  } delete itN2;

  //Compute the node partition
  vector< set<node > > result;
  int index=0;
  map<double,int> resultIndex;
  itN2=tmpGraph->getNodes();
  while (itN2->hasNext()) {
    node itn=itN2->next();
    double val=connected->getNodeValue(itn);
    if (resultIndex.find(val)!=resultIndex.end())
      result[resultIndex[val]].insert(itn);
    else {
      set<node> tmp;
      result.push_back(tmp);
      resultIndex[val]=index;
      result[index].insert(itn);
      ++index;
    }
  }delete itN2;

  delete connected;
  superGraph->delAllSubGraphs(tmpGraph);
  return result;
}

void drawGraph(SuperGraph *tmpg) {
  cerr << __PRETTY_FUNCTION__ << endl;
  bool cached,result;
  string errMsg;
  string layoutName;
  if (tmpg->numberOfNodes() > 300)
    layoutName = "Circular";
  else
    layoutName = "GEM (Frick)";
  string sizesName="Auto_sizing";
  tmpg->computeProperty(layoutName,tmpg->getLocalProperty<LayoutProxy>("viewLayout"),errMsg);
  /*  *tmpg->getLocalProperty<LayoutProxy>("viewLayout") = *tmpg->getLocalProperty<LayoutProxy>(layoutName,
										result, cached,
										errMsg);*/
  //  *tmpg->getLocalProperty<SizesProxy>("viewSize") = *tmpg->getLocalProperty<SizesProxy>(sizesName, result, cached,    errMsg);
  if (tmpg->numberOfNodes() < 300)
    tmpg->computeProperty(sizesName,tmpg->getLocalProperty<SizesProxy>("viewSize"),errMsg);
  //  tmpg->delLocalProperty(layoutName);
  //  tmpg->delLocalProperty(sizesName);
}

//==============================================================================
bool StrengthClustering::run() {
  cerr << __PRETTY_FUNCTION__ << endl;
  //  cerr << __PRETTY_FUNCTION__ << " Start" << endl;
  //  cout << "Average Path Length :" << TlpTools::averagePathLength(superGraph) << endl;
  //  cout << "Average clustering :" <<  TlpTools::averageCluster(superGraph) << endl; 
  bool cached,result;
  string errMsg;
  values = new MetricProxy(superGraph);
  result = superGraph->computeProperty("Strength", values, errMsg);
  double maxMQ=0;
  int numberOfStep=10;
  double threshold=0;
  double deltaThreshold=(values->getEdgeMax(superGraph)-values->getEdgeMin(superGraph))/numberOfStep;
  int debugI=1;
  //cerr << debugI++ << " ....." << endl;
  for (double i=values->getEdgeMin(superGraph);i<values->getEdgeMax(superGraph);i+=deltaThreshold) {
    vector< set<node > > tmp;
    tmp=computeNodePartition(i);
    double mq=computeMQValue(tmp);
    //cerr << i << " , " << mq  << " , " << tmp.size() << endl;
    if (mq>maxMQ) {
      threshold=i;
      maxMQ=mq;
    }
  }
  cout << " MQ value for clustering : " << maxMQ << endl << flush;
  //  cerr << debugI++ << " ....." << endl;
  vector< set<node > > tmp;
  tmp.clear();
  //  threshold=(values->getEdgeMax())*80/step;
  tmp = computeNodePartition(threshold);
  if (tmp.size()==1) {
    drawGraph(superGraph);
    if (dataSet!=0) {
      dataSet->set("strengthGraph",superGraph);
    }
    return true;
  }
  SuperGraph *tmpGraph=tlp::newCloneSubGraph(superGraph);
  //  cerr << debugI++ << " ....." << endl;
  map<SuperGraph *,SuperGraph *> mapGraph;
  for (unsigned int i=0;i<tmp.size();++i) {
    SuperGraph *tmpg=tlp::inducedSubGraph(tmpGraph,tmp[i]);
    double avPath=tlp::averagePathLength(tmpg);
    double avCluster=tlp::averageCluster(tmpg);
    /*    cout << "Average Path Length :" << avPath << endl;
    cout << "Average clustering  :" <<  avCluster << endl; 
    cout << "Number of nodes     :" <<  tmpg->numberOfNodes() << endl; 
    cout << "Number of edges     :" <<  tmpg->numberOfEdges() << endl; 
    */
    SuperGraph *tmpGr=tmpg;
    if ( tmp.size()>1 && avPath>1 && avPath<4 && avCluster>0.25 && tmpg->numberOfNodes()>10) {
      DataSet tmpData;
      tlp::clusterizeGraph(tmpg,errMsg,&tmpData,"Strength");
      tmpData.get("strengthGraph",tmpGr);
    }
    mapGraph[tmpg]=tmpGr;
    if (tmpg==tmpGr) {
      drawGraph(tmpg);
    }
    tmpg=tmpGr;
  }
  //  cerr << debugI++ << " ....." << endl;
  DataSet tmpData;
  tlp::clusterizeGraph(tmpGraph,errMsg,&tmpData,"QuotientClustering");
  superGraph->delLocalProperty("Strength");
  SuperGraph *quotientGraph;
  tmpData.get<SuperGraph *>("quotientGraph",quotientGraph);
  drawGraph(quotientGraph);
  if (dataSet!=0) {
    dataSet->set("strengthGraph",quotientGraph);
  }
  if (quotientGraph!=superGraph) {
    //  cerr << debugI++ << " .....A" << endl;
    SuperGraph *rootGraph=superGraph->getRoot();
    MetaGraphProxy *meta=rootGraph->getLocalProperty<MetaGraphProxy>("viewMetaGraph");
    MetaGraphProxy *meta2=rootGraph->getLocalProperty<MetaGraphProxy>("strengthMetaGraph");
    //  cerr << debugI++ << " .....B" << endl;
    Iterator<node> *itN=quotientGraph->getNodes();
    while (itN->hasNext()) {
      node itn=itN->next();
      meta2->setNodeValue(itn,meta->getNodeValue(itn));
      meta->setNodeValue(itn,mapGraph[meta->getNodeValue(itn)]);
    } delete itN;
    //  cerr << __PRETTY_FUNCTION__ << " End" << endl;
  }

  delete values;
  return true;
}
//================================================================================
bool StrengthClustering::check(string &erreurMsg) {
  erreurMsg="";
  return true;
}
//================================================================================
void StrengthClustering::reset() {
}
//================================================================================




