//-*-c++-*-
#ifndef _StrengthClustering_H
#define _StrengthClustering_H

#include <string>
#include <set>
#include <vector>

#include <tulip/TulipPlugin.h>

class MetricProxy;

/** \addtogroup clustering */
/*@{*/
class StrengthClustering:public Clustering { 
public:
  StrengthClustering(ClusterContext);
  ~StrengthClustering();
  bool run();
  bool check(std::string &);
  void reset();
private:
  double e(std::set<node> &U);
  double e(std::set<node> &U,std::set<node> &V);
  double s(std::set<node> &U,std::set<node> &V);
  double s(std::set<node> &U);
  double computeMQValue(std::vector< std::set<node> > partition);
  std::vector< std::set<node> > computeNodePartition(double threshold);
  MetricProxy * values;
};
/*@}*/
#endif
