#include <deque>
#include <tulip/GraphMeasure.h>
#include "Assortativity.h"

METRICPLUGIN(AssortativityMetric,"Assortativity","Auber/Munzner","18/06/2004","Alpha","0","1");


using namespace std;

AssortativityMetric::AssortativityMetric(const PropertyContext &context):Metric(context) {}
AssortativityMetric::~AssortativityMetric() {}

bool AssortativityMetric::run(){
  Iterator<node> *itN= superGraph->getNodes();
  while (itN->hasNext()) {
    double sum = 0;
    node n = itN->next();
    Iterator<node> *itNe=superGraph->getInOutNodes(n);
    while (itNe->hasNext()) {
      sum += superGraph->deg(itNe->next());
    } delete itNe;
    if (superGraph->deg(n) > 0)
      metricProxy->setNodeValue(n, sum / superGraph->deg(n));
    else
      metricProxy->setNodeValue(n, 0 );
  } delete itN;
  return true;
}
