#include <deque>
#include <tulip/GraphMeasure.h>
#include "Eccentricity.h"

METRICPLUGIN(EccentricityMetric,"Eccentricity","Auber/Munzner","18/06/2004","Alpha","0","1");


using namespace std;

EccentricityMetric::EccentricityMetric(const PropertyContext &context):Metric(context) 
{}

EccentricityMetric::~EccentricityMetric() {}

bool EccentricityMetric::run(){
  Iterator<node> *itN= superGraph->getNodes();
  for (unsigned int i=0; itN->hasNext(); ++i) {
    if (!pluginProgress->progress(i,superGraph->numberOfNodes())) break;
    node n = itN->next();
    MutableContainer<unsigned int> distance;
    double max = tlp::maxDistance(superGraph, n, distance,2);
    if (0 == max)
      metricProxy->setNodeValue(n,0);
    else
      metricProxy->setNodeValue(n,1/max);
  } delete itN;
  return pluginProgress->progress(100,100);
}
/*
double EccentricityMetric::computeValue(const node n ) {
  deque<node> fifo;
  MutableContainer<bool> visited;
  MutableContainer<unsigned int> distanceFromStartingNode;
  visited.setAll(false);
  distanceFromStartingNode.setAll(superGraph->numberOfNodes());

  fifo.push_back(n);
  visited.set(n.id, true);
  distanceFromStartingNode.set(n.id,0);
  unsigned int maxDistance = 0;

  while(!fifo.empty()) {
    node current = fifo.front();
    fifo.pop_front();
    if (n != current) {
      unsigned int minAncestorValue = superGraph->numberOfNodes();
      Iterator<node> *itN = superGraph->getInOutNodes(current);
      while (itN->hasNext())
	minAncestorValue = minAncestorValue <?  distanceFromStartingNode.get(itN->next().id) ;
      delete itN;
      distanceFromStartingNode.set(current.id, minAncestorValue + 1);
      maxDistance = maxDistance >? (minAncestorValue + 1);
    }

    Iterator<node> *itN = superGraph->getInOutNodes(current);
    while(itN->hasNext()) {
      node itn = itN->next();
      if (!visited.get(itn.id)) {
	fifo.push_back(itn);
	visited.set(itn.id,true);
      }
    } delete itN;
  }

  if (maxDistance==0) 
    return 0.0; // The node is isolated (deg=0) thus distance is infinite to the others
  else 
    return 1.0 / double(maxDistance);
  
  return maxDistance;
}

*/



