#include <cmath>
#include "SpreadingActivationMetric.h"
#include <tulip/MetricProxy.h>

METRICPLUGIN(SpreadingActivationMetric,"Spreading Activation","David Auber","18/06/2002","Ok","0","1")

SpreadingActivationMetric::SpreadingActivationMetric(const PropertyContext &context):Metric(context){}
SpreadingActivationMetric::~SpreadingActivationMetric(){}

bool SpreadingActivationMetric::run()
{
  stdext::hash_map<node,double> result1(superGraph->numberOfNodes()),result2(superGraph->numberOfNodes());
  stdext::hash_map<node,double>::iterator itMap,itMap2;
  unsigned int nb_iteration=superGraph->numberOfNodes();
  bool stopeval=false;

  Iterator<node> *it=superGraph->getNodes();
  for (;it->hasNext();) {
    node itn=it->next();
    result1[itn]=1;
  }delete it;

  stdext::hash_map<node,double> *inUse=&result2,*inBuf=&result1;
  for (unsigned int k=0;(k<nb_iteration) && (!stopeval);++k) {
    if (!pluginProgress->progress(k,nb_iteration)) break;
    double max=0;
    Iterator<node> *it=superGraph->getNodes();
    for (;it->hasNext();){
      node itn=it->next();
      double result=(*inBuf)[itn];
      Iterator<node> *itInNode=superGraph->getInNodes(itn);
      for (;itInNode->hasNext();) {
	node itn2=itInNode->next();
	result+=(*inBuf)[itn2];
      }delete itInNode;
      if (result>max) max=result;
      (*inUse)[itn]=result;
    }delete it;
    stopeval=true;
    for ( itMap=(*inUse).begin(),itMap2=(*inBuf).begin() ; itMap!=(*inUse).end() ; ++itMap,++itMap2 ) {
      (*itMap).second/=max;
      if (fabs((*itMap).second-(*itMap2).second)>0.00001) stopeval=false;
    }
    if (inUse==(&result1)) {
      inUse=&result2;
      inBuf=&result1;
    }
    else {
      inUse=&result1;
      inBuf=&result2;
    }
  }
  it=superGraph->getNodes();
  for (;it->hasNext();) {
    node itn=it->next();
    metricProxy->setNodeValue(itn,(*inBuf)[itn]);
  }delete it;

  return pluginProgress->progress(100,100);
}
