#include <tulip/AcyclicTest.h>
#include "Viennot.h"

METRICPLUGIN(ViennotMetric,"Viennot","David Auber","04/10/2001","Alpha","0","1");

using namespace std;

ViennotMetric::ViennotMetric(const PropertyContext &context):Metric(context) 
{}

ViennotMetric::~ViennotMetric() {}

double ViennotMetric::getNodeValue(const node n ) {
  if (superGraph->outdeg(n)==0) return 1;
  double valMax=-1;
  unsigned int nbValMax=0;
  Iterator<node> *itN=superGraph->getOutNodes(n);
  for (;itN->hasNext();){
    node itn=itN->next();
    double tmpVal=metricProxy->getNodeValue(itn);
    if (tmpVal>valMax) {
      valMax=tmpVal;
      nbValMax=1;
    }
    else {
      if (tmpVal==valMax) nbValMax++;
    }
  }delete itN;
  if (nbValMax>1) 
    return valMax+1; 
  else 
    return valMax;
}


bool ViennotMetric::check(string &err) {
  if (AcyclicTest::isAcyclic(superGraph)) {
    return true;
  }
  else {
    err="The graph must be acyclic";
    return false;
  }
}


