//-*-c++-*-

#ifndef viewGl_included
#define viewGl_included
#include <map>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <vector>
#include <qlistview.h>
#include <qtextview.h> 
#include <qsplitter.h>
#include <qpopupmenu.h>
#include <qstring.h>
#include <qmainwindow.h>
#include <pthread.h>
#include <string>
#include <tulip/Reflect.h>
#include <tulip/SuperGraph.h>
#include <tulip/Observable.h>
#include "TulipData.h"

class Cluster;
class QWorkspace;
class QProgressDialog;
class QEvent;
class PropertyDialog;
class NavigateGlGraph;
class GlGraphWidget;
class View3DSetup;
class ClusterTree;
class TulipElementProperties;
class ToolBar;
class Overview;

///Widget for manipulation and visualization of a graph
class viewGl : public TulipData, Observer {
  Q_OBJECT;

public:
  viewGl(QWidget *parent=NULL, const char *name=NULL);
  virtual ~viewGl();
  void setParameters(const DataSet);
  //  const GlGraphWidget *getGlGraphWidget() const;
  bool eventFilter(QObject *, QEvent *);

protected:
  ClusterTree *clusterTreeWidget;
  ToolBar *mouseToolBar;
  Overview *overviewWidget;
  QWidget *aboutWidget;
  QDockWindow *overviewDock;
  QDockWindow *tabWidgetDock;
  QDockWindow *mouseToolBarDock;
  GlGraphWidget *glWidget;
  PropertyDialog *propertiesWidget;
  TulipElementProperties *nodeProperties;
  SuperGraph * copyCutPasteGraph;


  //  QPopupMenu propertyMenu;
  QPopupMenu layoutMenu;
  QPopupMenu metricMenu;
  QPopupMenu colorsMenu;
  QPopupMenu sizesMenu;
  QPopupMenu intMenu;
  QPopupMenu stringMenu;
  QPopupMenu importGraphMenu;
  QPopupMenu exportGraphMenu;
  QPopupMenu graphMenu;
  //  QPopupMenu clusteringMenu;
  QPopupMenu optionMenu;
  //QPopupMenu viewMenu;
  QPopupMenu selectMenu;
  //QPopupMenu editMenu;
  QPopupMenu exportImageMenu;
  QPopupMenu dialogMenu;

  //QPopupMenu* windowsMenu;
  void focusInEvent ( QFocusEvent * );
  typedef std::set< Observable * >::iterator ObserverIterator;
  void update ( ObserverIterator begin, ObserverIterator end);
  void initObservers();
  void clearObservers();
  void timerEvent( QTimerEvent * );

public slots:
  void fileOpen(std::string *,QString &);

protected slots:
  void helpAbout();
  void fileExit();
  void fileSave();
  void fileSaveAs();
  int  closeWin();
  void windowActivated(QWidget *);
  void hierarchyChangeSuperGraph(SuperGraph *);
  void fileNew();
  void fileOpen();  
  void filePrint();
  void editCut();
  void editCopy();
  void editPaste();
  void editFind();
  void changeMetric(int);
  void changeString(int);
  void changeSizes(int);
  void changeColors(int);
  void changeInt(int);
  void changeSelection(int);
  void changeLayout(int);
  void importGraph(int);
  void exportGraph(int);
  void exportImage(int);
  void makeClustering(int );
  void outputEPS();
  void showDialog(int);
  void redrawView();
  void centerView();
  void updateSatutBar();
  void deselectALL();
  void reverseSelection();
  void delSelection();
  void newSubgraph();
  void reverseSelectedEdgeDirection();
  void windowsMenuAboutToShow();
  void windowsMenuActivated( int id );
  void restoreView();
  void new3DView();
  void goInside();
  void changeSuperGraph(SuperGraph *);
  void superGraphAboutToBeRemoved(SuperGraph *);

private:
  template<typename PROPERTY> bool changeProperty(std::string, std::string, bool = true );
  GlGraphWidget *newOpenGlView(SuperGraph *graph,const QString &);
  stdext::hash_map<unsigned int, std::string> openFiles;
  void buildMenus();
  bool fileSave(std::string plugin, std::string filename);
  unsigned int mouseClicX,mouseClicY;
};

#endif // viewGl_included
