#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/SuperGraph.h>
#include <tulip/LayoutProxy.h>
#include <tulip/ColorsProxy.h>
#include <tulip/GlGraphWidget.h>

#include "Application.h"
#include "MouseAddEdge.h"

using namespace std;
using namespace tlp;

MouseAddEdge::MouseAddEdge():started(false){}

void MouseAddEdge::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  ElementType type;
  node tmpNode;
  edge tmpEdge;
  SuperGraph*_superGraph=glGraphWidget->getGlGraph()->getSuperGraph();
  LayoutProxy* mLayout=_superGraph->getProperty<LayoutProxy>("viewLayout");
  ColorsProxy* mColors=_superGraph->getProperty<ColorsProxy>("viewColor");
  if (qMouseEv->button()==QEvent::LeftButton) {
      if (!started) {
	bool result=glGraphWidget->getGlGraph()->doSelect(qMouseEv->x(), qMouseEv->y(), type, tmpNode, tmpEdge);
	if (result && (type == NODE)) {
	  started=true;
	  source=tmpNode;
	  glGraphWidget->setMouseTracking(true);
	  curPos=startPos=mLayout->getNodeValue(source);
	}
      }
      else {
	bool result = glGraphWidget->getGlGraph()->doSelect(qMouseEv->x(),qMouseEv->y(),type,tmpNode,tmpEdge);
	if (result && (type == NODE)) {
	  Observable::holdObservers();
	  started=false;
	  glGraphWidget->setMouseTracking(false);
	  edge newEdge = glGraphWidget->getGlGraph()->getSuperGraph()->addEdge(source, tmpNode);
	  mLayout->setEdgeValue(newEdge, bends);
	  mColors->setEdgeValue(newEdge, ((Application *)qApp)->edgeColor);
	  bends.clear();
	  glGraphWidget->UpdateGL();
	  Observable::unholdObservers(); 
	}
	else {
	  double x1, y1, z1;
	  x1 = (double) glGraphWidget->width() - (double) qMouseEv->x(); y1 = (double) qMouseEv->y(); z1 = 0;
	  glGraphWidget->getGlGraph()->screenTo3DWorld(x1, y1, z1);
	  bends.push_back(Coord(x1, y1, z1));
	  glGraphWidget->UpdateGL();
	}
      }
  }
  if (qMouseEv->button()==QEvent::MidButton) {
      bends.clear();
      glGraphWidget->setMouseTracking(false);
      started=false;
      glGraphWidget->UpdateGL();
    }
  if (qMouseEv->button()==QEvent::RightButton){}
}
void MouseAddEdge:: mPaint(GlGraphWidget *glGraphWidget) {
  if (!started) return;
  float color[4];
  color[0]=1; color[1]=0;  color[2]=0;  color[3]=1;
  vector<Coord>::iterator lCoordIt=bends.begin();
  glGraphWidget->makeCurrent();
  glColor4fv(color);
  glBegin(GL_LINE_STRIP);{
    glVertex3f(startPos.getX(),startPos.getY(),startPos.getZ());
    while(lCoordIt!=bends.end()) {
      glVertex3f(lCoordIt->getX(),lCoordIt->getY(),lCoordIt->getZ());
      ++lCoordIt;
    }
    glVertex3f(curPos.getX(),curPos.getY(),curPos.getZ());
  }glEnd();
}
void MouseAddEdge:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {}
void MouseAddEdge:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (!started) return;
  double x1,y1,z1;
  x1 = (double) glGraphWidget->width() - (double) qMouseEv->x() ;y1 = (double) qMouseEv->y();z1 = 0;
  glGraphWidget->getGlGraph()->screenTo3DWorld(x1,y1,z1);
  curPos.set(x1,y1,z1);
  glGraphWidget->UpdateGL();
}
