//-*-c++-*-
#ifndef Tulip_GLGRAPH_WIDGET_H
#define Tulip_GLGRAPH_WIDGET_H
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qgl.h>
#include <qpoint.h>

#include <tulip/SuperGraph.h>
#include <tulip/GlGraph.h>
#include <tulip/GlDrawable.h>

#include "tulip/MouseInterface.h"

//class QTextView;
class QTimer;

class TLP_QT_SIMPLE_SCOPE GlGraphWidget : public QGLWidget, GlGraphStrategy
{
  Q_OBJECT;
  
public:
  GlGraphWidget(QWidget *parent=NULL, const char *name=NULL);
  GlGraphWidget(const GlGraphWidget &, QWidget *parent=NULL, const char *name=NULL);
  ~GlGraphWidget();

  GlGraph *getGlGraph() const;
  SuperGraph *getSuperGraph() const;
  MouseInterface *getMouse() const;
  virtual QImage grabFrameBuffer(bool withAlpha = false);

  void  initializeGL();
  void  paintGL();
  void  resizeGL(int w, int h);

  ///
  //  void  setQTextView(QTextView *);

  ///GlGraphStrategy ///////////////////
  void  MakeCurrent();
  void  UpdateGL();

  void  setExternal(GlDrawable *);
  GlDrawable *getExternal();
  bool  timerIsActive();
  int   timerStart(int, bool sshot=false);
  void  timerStop();
  
  void  mPaint(GlGraph *);
  //  void  outputSetText(const std::string&);
  //  const std::string outputGetText();
  //  void  update(std::set<Observable *>::iterator itb);

  void  addGlDrawable(GlDrawable *);
  void  removeGlDrawable(GlDrawable *);
  /////////////////////////////////////

  //MouseInterface implementation can use the following methods. Not very pretty...
  //(but they cannot be declared "friend" since they will not be "friend" in turn)
  //update: use clickAt, the proper signal will be emitted
  void clickAt(const int x, const int y);
  
  void clickAt(const QPoint &pos);
//   void emitNodeClicked(const node &);
//   void emitEdgeClicked(const edge &);
  //
  
public slots:
//  void setGlGraph(GlGraph *);
  void setSuperGraph(SuperGraph *);
  void setMouse(MouseInterface *);
  void deleteElement(int x, int y);
  void delSelection();
  void redraw();

  void setContextCoord(int x, int y);
  void contextDel();
  void contextSelect();
  void contextProperties();
  void contextAddRemoveSelection();

signals:
  void nodeClicked(SuperGraph *,const node &);
  void edgeClicked(SuperGraph *,const edge &);

protected slots:
  void drawGraph();
 
  void mouseReleaseEvent(QMouseEvent *e); 
  void mousePressEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void keyPressEvent(QKeyEvent *e);
  void keyReleaseEvent(QKeyEvent *e);
  void wheelEvent(QWheelEvent *e);

private:
  GlGraph *glGraph;
  
  //  QTextView *output;
  QTimer *drawTimer;

  int xContext,yContext;
  MouseInterface *mouse;
  GlDrawable *external;

};

#endif
