//-*-c++-*-
#ifndef TULIP_INTPROXY_H
#define TULIP_INTPROXY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"
#include "Int.h"

class Ggraph;
class PropertyContext;

/** \addtogroup properties */ 
/*@{*/
class TLP_SCOPE IntProxy:public PropertyProxy<IntType,IntType, Int>{ 

  friend class Int;

public :
  IntProxy (SuperGraph *);
  ~IntProxy();
  IntType::RealType  getNodeMin();
  IntType::RealType  getNodeMax();
  IntType::RealType  getEdgeMin();
  IntType::RealType  getEdgeMax();
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );


protected:
  void reset_handler();
  void recompute_handler();
  void clone_handler(PropertyProxy<IntType,IntType> &);

private:
  int maxN,minN,maxE,minE;
  bool minMaxOk;
  void computeMinMax();
};
/*@}*/
#endif
