//-*-c++-*-
#ifndef TULIP_METRICPROXY_H
#define TULIP_METRICPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"
#include "Metric.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class PropertyContext;

/** \addtogroup properties */ 
/*\@{*/
class TLP_SCOPE MetricProxy:public PropertyProxy<DoubleType,DoubleType,Metric> { 

  friend class Metric;

public :
  MetricProxy (SuperGraph *);
  ~MetricProxy();
  DoubleType::RealType  getNodeMin(SuperGraph *sg=0);
  DoubleType::RealType  getNodeMax(SuperGraph *sg=0);
  DoubleType::RealType  getEdgeMin(SuperGraph *sg=0);
  DoubleType::RealType  getEdgeMax(SuperGraph *sg=0);
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );
  void uniformQuantification(unsigned int);

protected:
  virtual void setNodeValue_handler(const node n);
  virtual void setEdgeValue_handler(const edge e);
  virtual void setAllNodeValue_handler();
  virtual void setAllEdgeValue_handler();
  void reset_handler();
  void recompute_handler();
  void clone_handler(PropertyProxy<DoubleType,DoubleType> &);

private:
  stdext::hash_map<int ,double> maxN,minN,maxE,minE;
  stdext::hash_map<int,bool> minMaxOkNode;
  stdext::hash_map<int,bool> minMaxOkEdge;
  void computeMinMaxNode(SuperGraph *sg=0);
  void computeMinMaxEdge(SuperGraph *sg=0);
};
/*@}*/
#endif
