#include "tulip/PropertyManager.h"

//================================================================================
template<typename ATTRIBUTETYPE>
ATTRIBUTETYPE SuperGraph::getAttribute(const std::string &name) {
  DataSet &data=getAttributes();
  ATTRIBUTETYPE tmp;
  data.get(name,tmp);
  return tmp;
}
//================================================================================
template<typename ATTRIBUTETYPE>
void SuperGraph::setAttribute(const std::string &name,const ATTRIBUTETYPE&value) {
  DataSet &data=getAttributes();
  data.set(name,value);
}
//================================================================================
template<typename Proxytype>
Proxytype* SuperGraph::getLocalProperty(const std::string &name) { 
  Proxytype *tmp;
  if (existLocalProperty(name)) {
    PProxy* tmpProxy=getProperty(name);
    assert ( typeid((*tmpProxy)) == typeid(Proxytype) );
    return ( (Proxytype *)(tmpProxy) );
  }
  else {
    PropertyManager *proxyManager=this->getPropertyManager();
    proxyManager->setLocalProxy(name,tmp=new Proxytype(this));
  }
  return (tmp);
}
//====================================================================================
template<typename Proxytype>
Proxytype* SuperGraph::getProperty(const std::string &name) {
  if (existProperty(name)) {
    PProxy* tmpProxy=getProperty(name);
    assert ( typeid((*tmpProxy)) == typeid(Proxytype) );
    return ( (Proxytype *)(tmpProxy) );
  }
  else {
    return getLocalProperty<Proxytype>(name);
  }
}
//====================================================================================
template<typename Proxytype>
bool SuperGraph::computeProperty(const std::string &algorithm, Proxytype result, std::string &msg, 
				 PluginProgress *progress, DataSet *data) {
  bool resultBool;
  PropertyContext context;

  PluginProgress *tmpProgress;
  if (progress==0) 
    tmpProgress=new PluginProgress();
  else 
    tmpProgress=progress;

  context.pluginProgress = tmpProgress;
  context.superGraph = this;
  context.dataSet = data;
  
  resultBool = result->compute(algorithm,msg,context);
  if (progress==0) delete tmpProgress;
  
  return resultBool;
}
//====================================================================================
