#include <float.h>
#include "tulip/MetaGraphProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/MetaGraph.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

//==============================
///Constructeur d'un MetaGraphProxy
MetaGraphProxy::MetaGraphProxy (SuperGraph *graph) : 
  PropertyProxy<MetaGraphType,MetaGraphType>(graph) {
}
//==============================
MetaGraphProxy::~MetaGraphProxy() {}    
//========================================================================
PProxy* MetaGraphProxy::clonePrototype(SuperGraph * g, std::string n) {
  if( !g )
    return 0;
  MetaGraphProxy * p = g->getLocalProperty<MetaGraphProxy>( n );
  p->setAllNodeValue( getNodeDefaultValue() );
  p->setAllEdgeValue( getEdgeDefaultValue() );
  return p;
}
//=============================================================
void MetaGraphProxy::copy( const node n0, const node n1, PProxy * p ) {
  if( !p )
    return;
  MetaGraphProxy * tp = dynamic_cast<MetaGraphProxy*>(p);
  assert( tp );
  setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void MetaGraphProxy::copy( const edge e0, const edge e1, PProxy * p ) {
  if( !p ) return;
  MetaGraphProxy * tp = dynamic_cast<MetaGraphProxy*>(p);
  assert( tp );
  setEdgeValue( e0, tp->getEdgeValue(e1) );
}
