//-*-c++-*-
#include <cmath>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <tulip/TulipPlugin.h>
#include <tulip/Color.h>

using namespace std;
///
inline float MIN(float a,float b) {
  return (a<b ? a : b);
}
inline float MAX(float a,float b) {
  return (a>b ? a : b);
}
void RGBtoHSV( float r, float g, float b, float *h, float *s, float *v )
{
  float min, max, delta;
  min = MIN( MIN( r, g) , b );
  max = MAX( MAX( r, g) , b );
  *v = max;                               // v
  delta = max - min;
  if( max != 0 )
    *s = delta / max;               // s
  else {
    // r = g = b = 0                // s = 0, v is undefined
    *s = 0;
    *h = -1;
    return;
  }
  if( r == max )
    *h = ( g - b ) / delta;         // between yellow & magenta
  else if( g == max )
    *h = 2 + ( b - r ) / delta;     // between cyan & yellow
  else
    *h = 4 + ( r - g ) / delta;     // between magenta & cyan
  *h *= 60;                               // degrees
  if( *h < 0 )
    *h += 360;
}

void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v )
{
        int i;
        float f, p, q, t;
        if( s == 0 ) {
                // achromatic (grey)
                *r = *g = *b = v;
                return;
        }
        h /= 60;                        // sector 0 to 5
        i = (int)floor( h );
        f = h - (float)i;                      // factorial part of h
        p = v * ( 1 - s );
        q = v * ( 1 - s * f );
        t = v * ( 1 - s * ( 1 - f ) );
        switch( i ) {
	case 0:
	  *r = v;
	  *g = t;
	  *b = p;
	  break;
	case 1:
	  *r = q;
	  *g = v;
	  *b = p;
	  break;
	case 2:
	  *r = p;
	  *g = v;
	  *b = t;
	  break;
	case 3:
	  *r = p;
	  *g = q;
	  *b = v;
	  break;
	case 4:
	  *r = t;
	  *g = p;
	  *b = v;
	  break;
	default:                // case 5:
	  *r = v;
	  *g = p;
	  *b = q;
	  break;
        }
}

class HistogramMapping:public Colors
{ 
private:
  std::map<double,double> colorMapping;
  double max,min;

public:
  HistogramMapping(const PropertyContext &context):Colors(context){}
  ~HistogramMapping(){}

  Color getNodeValue(const node n) {
    MetricProxy *entryMetric=superGraph->getProperty<MetricProxy>("viewMetric");
    ColorsProxy *entryColors=superGraph->getProperty<ColorsProxy>("viewColor");
    float h,s,v;
    float r,g,b;
    Color nodeBaseColor;
    nodeBaseColor=entryColors->getNodeValue(n);
    RGBtoHSV(nodeBaseColor.getRGL(),nodeBaseColor.getGGL(),nodeBaseColor.getBGL(),&h,&s,&v);
    double dd=entryMetric->getNodeValue(n);
    double ddd=(colorMapping[dd]);
    h=ddd*300.0+60;
    HSVtoRGB(&r,&g,&b,h,s,v);
    return Color((int)(r*255.0f),(int)(g*255.0f),(int)(b*255.0f),nodeBaseColor.getA());
  }

  bool run() {
#ifndef NDEBUG
    cerr << "HistogramMapping::colors" << endl;
#endif
    MetricProxy *entryMetric=superGraph->getProperty<MetricProxy>("viewMetric");
    colorMapping.clear();
    min=0;
    max=0;
    bool start=true;
    //===============================================================
    //build the histogram of values
    map<double,int> histogram;
    Iterator<node> *itN=superGraph->getNodes();
    for (;itN->hasNext();) {
      node itn=itN->next();
      double nodeValue=entryMetric->getNodeValue(itn);
      if (start) {
	max=nodeValue;
	min=nodeValue;
	start=false;
      }
      if (nodeValue>max) max=nodeValue;
      if (nodeValue<min) min=nodeValue;
      if (histogram.find(nodeValue)==histogram.end()) {
	histogram[nodeValue]=1;
      }
      else
	histogram[nodeValue]+=1;
    }delete itN;
    //===============================================================
    //Build the color map
    map<double,int>::iterator it;
    double ox=0,oy=0;
    double od=0;
    for (it=histogram.begin();it!=histogram.end();++it) {
      double x,y;
      x=(*it).first;
      y=(*it).second;
      od+=sqrt((x-ox)*(x-ox)+(y-oy)*(y-oy));
      ox=x;oy=y;
      colorMapping[x]=od;
    }
    max=colorMapping[max];
    min=colorMapping[min];
    //===============================================================
    if (fabs(max-min)<0.001) max=min+1;
    //===============================================================
    //Normalize
    map<double,double>::iterator itHash;
    itHash=colorMapping.begin();
    for (;itHash!=colorMapping.end();itHash++) {
      (*itHash).second=((*itHash).second-min)/(max-min);
    }
    //===============================================================
    return true;
  }
  bool check(string &err){
    return true;
  }
};
COLORSPLUGIN(HistogramMapping,"Distribution","Auber","04/05/2001","0","0","1");





  /*
void GlGraph::buildColor()
{
#ifndef NDEBUG
  cerr << "GlGraph::buildColor()" << endl;
#endif
  nodeColor=getProperty<MetricProxy>(_superGraph,"viewMetric");
  colorMap.clear();
  colorMapMin=0;
  colorMapMax=0;
  bool start=true;
  map<double,int> histo;
  Iterator<node> *itN=_superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    double nodeValue=nodeColor->getNodeValue(itn);
    if (start) {
      colorMapMax=nodeValue;
      colorMapMin=nodeValue;
      start=false;
    }
    if (nodeValue>colorMapMax) colorMapMax=nodeValue;
    if (nodeValue<colorMapMin) colorMapMin=nodeValue;
    
    if (histo.find(nodeValue)==histo.end()) {
      histo[nodeValue]=1;
    }
    else
      histo[nodeValue]+=1;
  }delete itN;
  map<double,int>::iterator it;
  double ox=0,oy=0;
  double od=0;
  double tmp=0;
  for (it=histo.begin();it!=histo.end();++it) {
    double x,y;
    x=(*it).first;
    y=(*it).second;
    if (_viewColorEntry==1) {
      od+=sqrt((x-ox)*(x-ox)+(y-oy)*(y-oy));
      ox=x;oy=y;
      colorMap[x]=od;
    }
    else
      if (_viewColorEntry==2) {
	colorMap[x]=tmp;
	tmp++;
      }
  }
  colorMapMin=colorMap[colorMapMin];
  colorMapMax=colorMap[colorMapMax];
}
*/
/*
void GlGraph::buildColor()
{
  colorMap.clear();
  colorMapMin=0;
  colorMapMax=0;
  bool start=true;
  map<double,int> histo;
  Iterator<edge> *itE=_superGraph->getEdges();
  for (;itE->hasNext();)
    {
      edge ite=itE->next();
      double edgeValue=nodeColor->getEdgeValue(ite);
      if (start)
	{
	  colorMapMax=edgeValue;
	  colorMapMin=edgeValue;
	  start=false;
	}
      if (edgeValue>colorMapMax) colorMapMax=edgeValue;
      if (edgeValue<colorMapMin) colorMapMin=edgeValue;

      if (histo.find(edgeValue)==histo.end())
	{
	  histo[edgeValue]=1;
	}
      else
	histo[edgeValue]+=1;
    }
  delete itE;
  map<double,int>::iterator it;

  double ox=0,oy=0;
  double od=0;
  for (it=histo.begin();it!=histo.end();++it)
    {
      double x,y;
      x=(*it).first;
      y=(*it).second;
      od+=sqrt((x-ox)*(x-ox)+(y-oy)*(y-oy));
      //od+=y;
      ox=x;oy=y;
      colorMap[x]=od;
    }
  colorMapMin=colorMap[colorMapMin];
  colorMapMax=colorMap[colorMapMax];
}
*/





