!include "MUI.nsh"
!include "WriteEnvStr.nsh"


Name "Tulip"
OutFile "TulipSetup.exe"
ComponentText "Installation de Tulip"
DirText "Repertoire d'instalation"
InstallDir "c:\Program Files\Tulip\"

!define MUI_HEADERIMAGE
!define MUI_WELCOMEFINISHPAGE_BITMAP "/home/auber\lib\tlp\bitmaps\logo.bmp"
!insertmacro MUI_PAGE_WELCOME


!insertmacro MUI_PAGE_LICENSE "COPYING"

!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH
!insertmacro MUI_LANGUAGE "English" 

Function .onInit
InitPluginsDir ;on initialise le rpertoire de dmarrage des plugins
File /oname=$PLUGINSDIR\splash.bmp "/home/auber\lib\tlp\bitmaps\logo.bmp" ;on copie l'image dans l'exe final et on on la met dans le dossier temporaire.
advsplash::show 1800 350 187 2 $PLUGINSDIR\splash
Pop $R0 ;on rcupre la valeur de retour : 1, si l'utilisateur a ferm l'cran, 0 si tout s'est bien pass, et -1 si un problme est survenu
Delete $PLUGINSDIR\spltmp.bmp ;idem pour l'image
FunctionEnd

Section "-Programme (requis)"
Push TULIP_PLUGINS_PATH
ReadEnvStr $R0 "TULIP_PLUGINS_PATH" 
StrCpy $R0 "$R0:$INSTDIR\lib\tlp\plugins"
Push $R0
Call WriteEnvStr
SetOutPath $INSTDIR
FILE /home/auber\lib\tlp\bitmaps\logo32x32.ico
FILE "${NSISDIR}\source\exehead\uninst.ico"
File /home/auber\bin\Tulip.exe
SectionEnd

Section "-Install Plugins"
setOutPath $SYSDIR
File "/home/auber\bin\libtulip-.dll" 
File "/home/auber\bin\libtulip-ogl-.dll" 
File "/home/auber\bin\libtulip-qt-.dll" 
File "\bin\iconv.dll"
File "\bin\zlib1.dll" 
File "\bin\freetype*.dll"
File "\bin\libxml*.dll"
File "\bin\libjpeg*.dll"
File "\bin\libpng*.dll"
File "\bin\mgwz.dll"
File "\bin\mingwm*.dll"
File "/usr/lib/qt-3.3/lib\qt-mt*.dll" 
setOutPath $INSTDIR\lib
File "/home/auber\bin\libtulip-.dll" 
File "/home/auber\bin\libtulip-ogl-.dll" 
File "/home/auber\bin\libtulip-qt-.dll" 
setOutPath $INSTDIR\lib\tlp\bitmaps
File /home/auber\lib\tlp\bitmaps\*
setOutPath $INSTDIR\lib\tlp\plugins\clustering
File /home/auber\lib\tlp\plugins\clustering\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\colors
File /home/auber\lib\tlp\plugins\colors\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\designer
File /home/auber\lib\tlp\plugins\designer\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\export
File /home/auber\lib\tlp\plugins\export\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\glyph
File /home/auber\lib\tlp\plugins\glyph\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\import
File /home/auber\lib\tlp\plugins\import\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\layout
File /home/auber\lib\tlp\plugins\layout\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\metric
File /home/auber\lib\tlp\plugins\metric\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\selection
File /home/auber\lib\tlp\plugins\selection\*.dll
setOutPath $INSTDIR\lib\tlp\plugins\sizes
File /home/auber\lib\tlp\plugins\sizes\*.dll
SectionEnd


Section "Shortcuts" raccourcis
SetOutPath "$SMPROGRAMS\Tulip"
CreateShortCut "$SMPROGRAMS\Tulip\Tulip.lnk" "$INSTDIR\Tulip.exe" "" "$INSTDIR\logo32x32.ico"
CreateShortCut "$SMPROGRAMS\Tulip\Uninstall.lnk" "$INSTDIR\uninst-Tulip.exe" "" "$INSTDIR\uninst.ico"
SetOutPath "$DESKTOP\Tulip"
CreateShortCut "$DESKTOP\Tulip.lnk" "$INSTDIR\Tulip.exe" "" "$INSTDIR\logo32x32.ico"
SectionEnd

Section "SDK" sdk
setOutPath $INSTDIR\include\tulip
File /home/auber\include\tulip\*.h
setOutPath $INSTDIR\include\tulip\cxx
File /home/auber\include\tulip\cxx\*.cxx
SectionEnd

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${raccourcis} "Create a shortcut on the Desktop, and in the start menu"
	!insertmacro MUI_DESCRIPTION_TEXT ${sdk} "Install the sdk version, install the include files in the Tulip directory"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Section -PostInstall
WriteRegStr HKLM Software\Microsoft\Windows\CurrentVersion\Uninstall\Tulip DisplayName "Tulip (dsinstallation)"
WriteRegStr HKLM Software\Microsoft\Windows\CurrentVersion\Uninstall\Tulip UninstallString '"$INSTDIR\uninst-Tulip.exe"'
WriteUninstaller "uninst-Tulip.exe"
WriteRegStr HKLM "Software\Tulip" "Repertoire" '"$INSTDIR"'
SectionEnd

UninstallText "Voulez-vous vraiment enlever Tulip de votre systme ?"

Section "Uninstall"
DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Tulip"
DeleteRegKey HKLM "Software\Tulip"
Delete "$INSTDIR\Tulip.exe"
;Delete "$INSTDIR\Tulip.txt"
Delete "$INSTDIR\uninst-Tulip.exe"
Delete "$INSTDIR\logo32x32.ico"
Delete "$INSTDIR\uninst.ico"
Delete "$DESKTOP\Tulip.lnk"
Delete "$SMPROGRAMS\Tulip\*.*"
RMDir "$SMPROGRAMS\Tulip"
Delete $SYSDIR\libtulip-.dll
Delete $SYSDIR\libtulip-qt-.dll
Delete $SYSDIR\libtulip-ogl-.dll
Delete $SYSDIR\qt-mt*.dll
Delete $SYSDIR\zlib1.dll
Delete $SYSDIR\freetype*.dll
Delete $SYSDIR\libxml*.dll
Delete $SYSDIR\libjpeg*.dll
Delete $SYSDIR\libpng*.dll
Delete $SYSDIR\iconv.dll
Delete $SYSDIR\mgwz.dll
Delete $SYSDIR\mingwm*.dll
Delete "$INSTDIR\lib\tlp\bitmaps\*"
RMDir "$INSTDIR\lib\tlp\bitmaps"
Delete "$INSTDIR\lib\tlp\plugins\clustering\*"
RMDir "$INSTDIR\lib\tlp\plugins\clustering"
Delete "$INSTDIR\lib\tlp\plugins\colors\*"
RMDir "$INSTDIR\lib\tlp\plugins\colors"
Delete "$INSTDIR\lib\tlp\plugins\designer\*"
RMDir "$INSTDIR\lib\tlp\plugins\designer"
Delete "$INSTDIR\lib\tlp\plugins\export\*"
RMDir "$INSTDIR\lib\tlp\plugins\export"
Delete "$INSTDIR\lib\tlp\plugins\glyph\*"
RMDir "$INSTDIR\lib\tlp\plugins\glyph"
Delete "$INSTDIR\lib\tlp\plugins\import\*"
RMDir "$INSTDIR\lib\tlp\plugins\import"
Delete "$INSTDIR\lib\tlp\plugins\layout\*"
RMDir "$INSTDIR\lib\tlp\plugins\layout"
Delete "$INSTDIR\lib\tlp\plugins\metric\*"
RMDir "$INSTDIR\lib\tlp\plugins\metric"
Delete "$INSTDIR\lib\tlp\plugins\selection\*"
RMDir "$INSTDIR\lib\tlp\plugins\selection"
Delete "$INSTDIR\lib\tlp\plugins\sizes\*"
RMDir "$INSTDIR\lib\tlp\plugins\sizes"
RMDir "$INSTDIR\lib\tlp\plugins"
Delete "$INSTDIR\lib\tlp\*"
RMDir "$INSTDIR\lib\tlp"
Delete "$INSTDIR\lib\*"
RMDir "$INSTDIR\lib"
Delete "$INSTDIR\include\tulip\cxx\*"
RMDir "$INSTDIR\include\tulip\cxx"
Delete "$INSTDIR\include\tulip\*"
RMDir "$INSTDIR\include\tulip"
RMDir "$INSTDIR\include"
RMDir $INSTDIR
SectionEnd
