#ifndef GLAD_COMPOSITE_H
#define GLAD_COMPOSITE_H

#include "GlAugmentedDisplay.h"
#include <map>
#include <string>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

namespace tlp {
class TLP_GL_SCOPE GlADComposite : public GlAugmentedDisplay {

 protected:
  stdext::hash_map<string, GlAugmentedDisplay*> elements;

 public:
  GlADComposite();
  ~GlADComposite();

  void reset(bool deleteElems);

  void addGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay, const string & key);

  void deleteGlAugmentedDisplay(const std::string & key);
  void deleteGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay);

  GlAugmentedDisplay* findGlAugmentedDisplay(const string & key);

  void draw(GlGraph *graph);
};
}
#endif
