#include "tulip/GlADComposite.h"

using namespace tlp;
using namespace std;

namespace tlp {
  typedef stdext::hash_map<string, GlAugmentedDisplay *>::const_iterator ITM;
    //============================================================
  GlADComposite::GlADComposite() {
  }
  //============================================================
  GlADComposite::~GlADComposite() {
    reset(false);
  }
  //============================================================
  void GlADComposite::reset(bool deleteElems) {
    if (deleteElems)
      for(ITM i = elements.begin(); i != elements.end(); i++)
	delete (*i).second;
    elements.clear();
  }
  //============================================================
  void GlADComposite::addGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay, const string &key) {
    elements[key] = augmentedDisplay;
  }
  //============================================================
  void GlADComposite::deleteGlAugmentedDisplay(const string &key) {
    elements.erase(key);
  }
  //============================================================
  void GlADComposite::deleteGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay) {
    for(ITM i = elements.begin(); i != elements.end(); i++) {
      if(augmentedDisplay == (*i).second) {
	elements.erase((*i).first);
	return;
      }
    }
  }
  //============================================================
  GlAugmentedDisplay* GlADComposite::findGlAugmentedDisplay(const string &key) {
    ITM ite = elements.find(key);
    if (ite == elements.end())
      return NULL;
    return (*ite).second;
  }
  //============================================================
  void GlADComposite::draw(GlGraph *graph) {
    for(ITM ite = elements.begin(); ite != elements.end(); ite++)
      (*ite).second->draw(graph);
  }
  //============================================================
}
