//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 05/08/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHudRect.h"

using namespace std;

namespace tlp
{
  GlHudRect::GlHudRect() {
  }
  
  GlHudRect::GlHudRect(const Coord &topLeftPos, const Coord &bottomRightPos, const Color &topLeftCol, const Color &bottomRightCol):
    topLeftPos(topLeftPos),
    bottomRightPos(bottomRightPos),
    topLeftCol(topLeftCol),
    bottomRightCol(bottomRightCol) {
  }
  //=====================================================
  GlHudRect::~GlHudRect()  {
  }
  //=====================================================
  void GlHudRect::draw(GlGraph *graph) {
    setup();

    Coord points[N_RECT_POINTS];
    Color cols[N_RECT_POINTS];

    points[0] = topLeftPos;
    points[1][0] = bottomRightPos.getX();
    points[1][1] = topLeftPos.getY();
    points[1][2] = topLeftPos.getZ();
    points[2] = bottomRightPos;
    points[3][0] = topLeftPos.getX();
    points[3][1] = bottomRightPos.getY();
    points[3][2] = bottomRightPos.getZ();

    cols[0] = topLeftCol;

    for(int i=0; i < 4; i++) {
      cols[1][i] = ((topLeftCol)[i] + (bottomRightCol)[i]) / 2;
      cols[3][i] = cols[1][i];
    }

    GLfloat* glCols[N_RECT_POINTS];

    for(int i=0; i < N_RECT_POINTS; i++)
      glCols[i] = cols[i].getGL();

    cols[2] = bottomRightCol;

    for(int i=0; i < N_RECT_POINTS; i++)
      points[i] = transformCoordinates(points[i]);

    if (getRenderState(GlAD_Solid)) {
      glBegin(GL_QUADS);
      for(int i=0; i < N_RECT_POINTS; i++) {
	GLfloat *col = cols[i].getGL();
	glColor4fv(col);
	glVertex3d(points[i][0], points[i][1], points[i][2]);
      }
      glEnd();
    }
    
    if (getRenderState(GlAD_Wireframe)) {
      glBegin(GL_LINE_STRIP);
      if (getRenderState(GlAD_Solid)) {
	GLfloat colBk[4] = {0.0f, 0.0f, 0.0f, 255.0f};
	for(int i=0; i < N_RECT_POINTS; i++)
	  glCols[i] = colBk;
      }
      for(int i=0; i <= N_RECT_POINTS; i++) {
	int id = i % N_RECT_POINTS;
	glColor4fv(glCols[id]);
	glVertex3d(points[id][0], points[id][1], points[id][2]);
      }
      glEnd();
    }
    
    unsetup();
  }
  //=====================================================
  Coord GlHudRect::getTopLeftPos() {
    return topLeftPos;
  }
  //=====================================================
  Coord GlHudRect::getBottomRightPos() {
    return bottomRightPos;
  }
  //=====================================================
  Color GlHudRect::getTopLeftColor() {
    return topLeftCol;
  }
 //=====================================================
  Color GlHudRect::getBottomRightColor() {
    return bottomRightCol;
  }
 //=====================================================
  void GlHudRect::setTopLeftPos(const Coord &_topLeftPos) {
    topLeftPos = _topLeftPos;
  }
 //=====================================================
  void GlHudRect::setBottomRightPos(const Coord &_bottomRightPos) {
    bottomRightPos = _bottomRightPos;
  }
 //=====================================================
  void GlHudRect::setTopLeftColor(const Color &_topLeftCol) {
   topLeftCol = _topLeftCol;
  }
 //=====================================================
  void GlHudRect::setBottomRightColor(const Color &_bottomRightCol) {
    bottomRightCol = _bottomRightCol;
  }
  //=====================================================
  bool GlHudRect::inRect(double x, double y) {
    double minX = (topLeftPos.getX() < bottomRightPos.getX() ? topLeftPos.getX() : bottomRightPos.getX());
    double maxX = (topLeftPos.getX() > bottomRightPos.getX() ? topLeftPos.getX() : bottomRightPos.getX());
    double minY = (topLeftPos.getY() < bottomRightPos.getY() ? topLeftPos.getY() : bottomRightPos.getY());
    double maxY = (topLeftPos.getY() > bottomRightPos.getY() ? topLeftPos.getY() : bottomRightPos.getY());    
    return ((x >= minX) && 
	    (x <= maxX) && 
	    (y >= minY) && 
	    (y <= maxY));
  }
  //=====================================================
}
