#ifndef PROPERTYWIDGETS_H
#define PROPERTYWIDGETS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif
#include <string>

#if (QT_REL == 3)
#include <qwidget.h>
#include <qscrollbar.h>
#else
#include <QtGui/qwidget.h>
#include <QtGui/qscrollbar.h>
#include "Qt3ForTulip.h"
#endif

#include <tulip/SuperGraph.h>
#include <tulip/Size.h>
#include <tulip/Coord.h>
#include <tulip/TulipTableWidget.h>

typedef stdext::hash_map<int, std::string> GlyphTableString;

class PProxy;
/** \addtogroup Tulip_Widgets */ 
/*@{*/
/* this table handle displaying and editing node or edge properties */
class TLP_QT_SIMPLE_SCOPE TulipPropertyTable : public TulipTableWidget {
  Q_OBJECT;

private:
  SuperGraph *supergraph;

public:
  TulipPropertyTable(QWidget *, const char * = 0);
  ~TulipPropertyTable();
  SuperGraph *getSuperGraph() const;

public slots:
  void setSuperGraph(SuperGraph *);

private :
  QScrollBar *vScroll;
  int vScrollPos;
  bool displayNode;
  bool _filterSelection;
  SelectionProxy *filter;
  unsigned int nbElement;
  PProxy *editedProperty;
  std::string editedPropertyName;

public slots:  
  void changeProperty(SuperGraph *,const std::string &name);
  void selectNodeOrEdge(bool );
  void changePropertyValue(int,int);
  void changePropertyNodeValue(int,int);
  void changePropertyEdgeValue(int,int);
  void filterSelection(bool);
  void scroll(int);
  void update();
  void updateNodes();
  void updateEdges();
  void updateNbElements();
  void setAllEdgeValue();
  void setAllNodeValue();
  void setAll();

signals:
  void tulipNodePropertyChanged(SuperGraph *, const node &, const QString &property, const QString &value);
  void tulipEdgePropertyChanged(SuperGraph *, const edge &, const QString &property, const QString &value);
};
/*@}*/
#endif //PROPERTYWIDGETS_H
