//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHudRect.h"

using namespace std;

namespace tlp {

  GlHudRect::GlHudRect(const Coord &topLeftPos, const Coord &bottomRightPos, const Color &topLeftCol, const Color &bottomRightCol):
    GlHudPolygon(4u,4u, 0, true, false) {
    point(0) = topLeftPos;
    point(1) = topLeftPos;
    point(1)[0] = bottomRightPos[0];
    point(2) = bottomRightPos ;
    point(3) = topLeftPos;
    point(3)[1] = bottomRightPos[1]; 

    fcolor(0) = topLeftCol;
    fcolor(1) = topLeftCol;
    fcolor(2) = bottomRightCol ;
    fcolor(3) = bottomRightCol;
  }
  GlHudRect::GlHudRect():GlHudPolygon(4u,4u) {
  }
  //=====================================================
  GlHudRect::~GlHudRect()  {
  }
  //=====================================================
  Coord GlHudRect::getCenter()  {
    return (point(0) + point(2)) / 2.0;
  }
  //=====================================================
  Coord GlHudRect::getTopLeftPos() {
    return point(0);
  }
  //=====================================================
  Coord GlHudRect::getBottomRightPos() {
    return point(2);
  }
  //=====================================================
  Color GlHudRect::getTopLeftColor() {
    return fcolor(0);
  }
  //=====================================================
  Color GlHudRect::getBottomRightColor() {
    return fcolor(2);
  }
  //=====================================================
  void GlHudRect::setTopLeftPos(const Coord &_topLeftPos) {
    point(0) = _topLeftPos;
    point(1)[1] = _topLeftPos[1];
    point(3)[0] = _topLeftPos[0];
  }
  //=====================================================
  void GlHudRect::setBottomRightPos(const Coord &_bottomRightPos) {
    point(2) = _bottomRightPos;
    point(1)[0] = _bottomRightPos[0];
    point(3)[1] = _bottomRightPos[1];
  }
  //=====================================================
  void GlHudRect::setTopLeftColor(const Color &_topLeftCol) {
    fcolor(0) = _topLeftCol;
    fcolor(1) = _topLeftCol;
  }
  //=====================================================
  void GlHudRect::setBottomRightColor(const Color &_bottomRightCol) {
    fcolor(2) = _bottomRightCol;
    fcolor(3) = _bottomRightCol;
  }
  //=====================================================
  bool GlHudRect::inRect(double x, double y) {
    double minX = std::min(point(0).getX(), point(2).getX());
    double maxX = std::max(point(0).getX(), point(2).getX());
    double minY = std::min(point(0).getY(), point(2).getY());
    double maxY = std::max(point(0).getY(), point(2).getY());
    return ((x >= minX) && 
	    (x <= maxX) && 
	    (y >= minY) && 
	    (y <= maxY));
  }
  //=====================================================
}
