//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <math.h>
#ifndef GEO_2D
#define GEO_2D

#ifndef M_PI
#define M_PI 3.14159265
#endif

typedef struct {double x,y;} point;
//---------------------------------------------
// Calcule l'angle orient BA,BC dans le sens
// trigonomtrique
//---------------------------------------------
double angleABC(const double xA,const double yA,
		const double xB,const double yB,
		const double xC,const double yC);
//---------------------------------------------
// rotation du point B autour du point A de l'angle 
// Alpha.
//---------------------------------------------
void rotABAlpha(const double xA,const double yA,double &xB, double &yB,
		const double alpha);
void projABCircle(const double xA,const double yA,double &xB, double &yB,
		const double r);
void rotate(float calpha,float salpha ,point *p);
#endif





