#Boa:Dialog:RecordStream
#TunaPie (c)2005-2007 James Stone. Released under the GNU GPL.
#Written using Boa-Constructor.
#Version 0.0.6 08/01/07

import wx
import wx.lib.masked.textctrl
import wx.lib.intctrl
import wx.lib.masked.timectrl
import wx.lib.stattext
import tuner
import popen2
import urllib
#import mx.DateTime
import time

def create(parent):
    return RecordStream(parent)

[wxID_RECORDSTREAM, wxID_RECORDSTREAMCANCELBUTTON, 
 wxID_RECORDSTREAMDATECHOICE, wxID_RECORDSTREAMGENSTATICTEXT1, 
 wxID_RECORDSTREAMGENSTATICTEXT2, wxID_RECORDSTREAMGENSTATICTEXT3, 
 wxID_RECORDSTREAMGENSTATICTEXT4, wxID_RECORDSTREAMGENSTATICTEXT5, 
 wxID_RECORDSTREAMGENSTATICTEXT6, wxID_RECORDSTREAMLATERRADIO, 
 wxID_RECORDSTREAMMONTHCHOICE, wxID_RECORDSTREAMNOWRADIO, 
 wxID_RECORDSTREAMOKBUTTON, wxID_RECORDSTREAMSTOPHOURS, 
 wxID_RECORDSTREAMSTOPMINS, wxID_RECORDSTREAMTIME, 
] = [wx.NewId() for _init_ctrls in range(16)]

class RecordStream(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_RECORDSTREAM, name=u'RecordStream',
              parent=prnt, pos=wx.Point(354, 256), size=wx.Size(280, 216),
              style=wx.DEFAULT_DIALOG_STYLE, title=u'Record Stream')
        self.SetClientSize(wx.Size(280, 216))
        self.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.SetThemeEnabled(True)

        self.genStaticText1 = wx.lib.stattext.GenStaticText(ID=wxID_RECORDSTREAMGENSTATICTEXT1,
              label=u'Start Recording', name='genStaticText1', parent=self,
              pos=wx.Point(8, 8), size=wx.Size(75, 17), style=0)
        self.genStaticText1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.genStaticText1.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.genStaticText1.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText1.SetThemeEnabled(True)

        self.nowradio = wx.RadioButton(id=wxID_RECORDSTREAMNOWRADIO,
              label=u'Immediately!', name=u'nowradio', parent=self,
              pos=wx.Point(24, 32), size=wx.Size(112, 24), style=0)
        self.nowradio.SetValue(True)
        self.nowradio.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.nowradio.SetThemeEnabled(True)

        self.laterradio = wx.RadioButton(id=wxID_RECORDSTREAMLATERRADIO,
              label=u'At:', name=u'laterradio', parent=self, pos=wx.Point(24,
              64), size=wx.Size(48, 24), style=0)
        self.laterradio.SetValue(False)
        self.laterradio.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.laterradio.SetThemeEnabled(True)

        self.time = wx.lib.masked.timectrl.TimeCtrl(display_seconds=True,
              fmt24hr=False, id=wxID_RECORDSTREAMTIME, name=u'time',
              oob_color=wx.NamedColour('Yellow'), parent=self, pos=wx.Point(72,
              64), size=wx.Size(53, 22), style=0, useFixedWidthFont=True,
              value=u'00:00')
        self.time.SetFormat('24HHMM')
        self.time.SetBestFittingSize(wx.Size(53, 22))

        self.genStaticText2 = wx.lib.stattext.GenStaticText(ID=wxID_RECORDSTREAMGENSTATICTEXT2,
              label=u'(H:M 24H)', name='genStaticText2', parent=self,
              pos=wx.Point(176, 72), size=wx.Size(51, 17), style=0)
        self.genStaticText2.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.genStaticText2.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.genStaticText2.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText2.SetThemeEnabled(True)

        self.genStaticText3 = wx.lib.stattext.GenStaticText(ID=wxID_RECORDSTREAMGENSTATICTEXT3,
              label=u'On:', name='genStaticText3', parent=self, pos=wx.Point(24,
              104), size=wx.Size(17, 17), style=0)
        self.genStaticText3.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.genStaticText3.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.genStaticText3.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText3.SetThemeEnabled(True)

        self.monthchoice = wx.Choice(choices=['January', 'February', 'March',
              'April', 'May', 'June', 'July', 'August', 'September', 'October',
              'November', 'December'], id=wxID_RECORDSTREAMMONTHCHOICE,
              name=u'monthchoice', parent=self, pos=wx.Point(112, 104),
              size=wx.Size(120, 24), style=0)
        self.monthchoice.SetSelection(0)
        self.monthchoice.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.monthchoice.SetThemeEnabled(True)

        self.cancelbutton = wx.Button(id=wxID_RECORDSTREAMCANCELBUTTON,
              label=u'Cancel', name=u'cancelbutton', parent=self,
              pos=wx.Point(24, 184), size=wx.Size(96, 24), style=0)
        self.cancelbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.cancelbutton.SetThemeEnabled(True)
        self.cancelbutton.Bind(wx.EVT_BUTTON, self.OnCancelbuttonButton,
              id=wxID_RECORDSTREAMCANCELBUTTON)

        self.OKbutton = wx.Button(id=wxID_RECORDSTREAMOKBUTTON, label=u'OK',
              name=u'OKbutton', parent=self, pos=wx.Point(160, 184),
              size=wx.Size(96, 24), style=0)
        self.OKbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.OKbutton.SetThemeEnabled(True)
        self.OKbutton.SetDefault()
        self.OKbutton.Bind(wx.EVT_BUTTON, self.OnOKbuttonButton,
              id=wxID_RECORDSTREAMOKBUTTON)

        self.datechoice = wx.Choice(choices=["1", "2", "3", "4", "5", "6", "7",
              "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18",
              "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29",
              "30", "31"], id=wxID_RECORDSTREAMDATECHOICE, name=u'datechoice',
              parent=self, pos=wx.Point(56, 104), size=wx.Size(48, 24),
              style=0)
        self.datechoice.SetSelection(0)
        self.datechoice.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.datechoice.SetThemeEnabled(True)

        self.genStaticText4 = wx.lib.stattext.GenStaticText(ID=wxID_RECORDSTREAMGENSTATICTEXT4,
              label=u'Stopping in', name='genStaticText4', parent=self,
              pos=wx.Point(24, 144), size=wx.Size(53, 17), style=0)
        self.genStaticText4.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.genStaticText4.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.genStaticText4.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText4.SetThemeEnabled(True)

        self.stophours = wx.lib.intctrl.IntCtrl(allow_long=False,
              allow_none=False, default_color=wx.BLACK,
              id=wxID_RECORDSTREAMSTOPHOURS, limited=False, max=None, min=None,
              name=u'stophours', oob_color=wx.RED, parent=self,
              pos=wx.Point(104, 144), size=wx.Size(24, 22), style=0, value=0)
        self.stophours.SetThemeEnabled(True)

        self.stopmins = wx.lib.intctrl.IntCtrl(allow_long=False,
              allow_none=False, default_color=wx.BLACK,
              id=wxID_RECORDSTREAMSTOPMINS, limited=False, max=None, min=None,
              name=u'stopmins', oob_color=wx.RED, parent=self, pos=wx.Point(176,
              144), size=wx.Size(24, 22), style=0, value=0)
        self.stopmins.SetThemeEnabled(True)

        self.genStaticText5 = wx.lib.stattext.GenStaticText(ID=wxID_RECORDSTREAMGENSTATICTEXT5,
              label=u'hours', name='genStaticText5', parent=self,
              pos=wx.Point(136, 152), size=wx.Size(27, 17), style=0)
        self.genStaticText5.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.genStaticText5.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.genStaticText5.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText5.SetThemeEnabled(True)

        self.genStaticText6 = wx.lib.stattext.GenStaticText(ID=wxID_RECORDSTREAMGENSTATICTEXT6,
              label=u'minutes', name='genStaticText6', parent=self,
              pos=wx.Point(208, 152), size=wx.Size(37, 17), style=0)
        self.genStaticText6.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.genStaticText6.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.genStaticText6.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText6.SetThemeEnabled(True)

    def __init__(self, parent):
        self._init_ctrls(parent)
        timenow=time.localtime(time.time())
        #date,time=str(mx.DateTime.now()).split()
        self.year,self.month,self.day=str(timenow[0]),str(timenow[1]),str(timenow[2])
        self.hours,self.minutes=str(timenow[3]),str(timenow[4])
        self.time.SetValue(self.hours+':'+self.minutes)
        self.monthchoice.SetSelection(int(self.month)-1)
        self.datechoice.SetSelection(int(self.day)-1)
        
    def setfontsize(self, newsize):
        size=int(newsize)
        self.genStaticText1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.nowradio.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.laterradio.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText2.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText3.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.monthchoice.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Helvetica'))
        self.cancelbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.OKbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.datechoice.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText4.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText5.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText6.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
    
    def setoptions(self, recordoptions):
        self.recordoptions=recordoptions
        return

    def OnCancelbuttonButton(self, event):
        self.Close()

    def OnOKbuttonButton(self, event):
        ripper=self.recordoptions[1]
        pls=self.recordoptions[2]
        rdir=self.recordoptions[3]
        playlist=urllib.urlopen(pls)
        tempfile=playlist.read()
        url=tempfile[tempfile.find('//')+2:tempfile.find('\n',50)]
        r=ripper.split(' ')
        if (self.nowradio.GetValue()==True):
            args=' -e '+r[0]
        else:
            args=r[0]
        args+=' http://'+url
        i=0
        directoryset=0
        for argument in r:
            i+=1
            if i==1: continue
            args+=' '+argument
            if argument=='-d':
                directoryset=1
        if not(directoryset):
            args+=' -d'
            args+=' '+rdir
        if (self.nowradio.GetValue()==True):
            tuner.recordselection(self.recordoptions[0], args)
            self.Close()
            return
        args +=' -l '+str((self.stophours.GetValue()*3600)+(self.stopmins.GetValue()*60))     
        print ('at '+self.time.GetValue()+' '+self.monthchoice.GetStringSelection()\
            +' '+self.datechoice.GetStringSelection()+'\n'+'call: '+args)
        atcommand=popen2.Popen4('at '+self.time.GetValue()+' '+self.monthchoice.GetStringSelection()\
            +' '+self.datechoice.GetStringSelection())
        atcommand.tochild.write(args)
        atcommand.tochild.close()
        self.Close()
