<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup company
 * @module company_overview
 * @package company
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("company","overview");
 loadlayout();

 /**
  * show a overview of comapanies
  */
 class company_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $n = $this->result->numrows();
     echo $this->actionformStart("company_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("name",$lang['Company'],$this->link2);
     echo $this->orderHeader("",$lang['Department'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new company($this->dbconn);
       $c->read_result($this->result,$a);
       $c->read_departments();
       $a++;
       if (! $c->see_ok() ) {
         continue;
       }


       $rs = max(count($c->deplist),1);
       echo $this->OverviewRowStart($a);
       echo "<td valign=\"top\" rowspan=\"". $rs ."\">". $c->getLink() ."</td>";
       $x = 1;
       foreach($c->deplist as $i => $f) {
         if ( $x > 1 ) {
           echo $this->OverviewRowStart($a);
	     }
         echo "<td> ". $f->getLink($f->name) ."</td>\n";

         if ( ($x == 1) && ($tutos[massupdate] == 1) ) {
           echo " <td rowspan=\"". $rs ."\" align=\"center\">\n";
           if ( $c->mod_ok() ) {
             echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $c->id ."\">\n";
           } else {
             echo "-\n";
           }
           echo "</td>\n";
         }

         echo $this->OverviewRowEnd($a);
	     $x++;
       }
       if ( $x == 1 ) {
         echo "<td>&nbsp;</td>\n";
         if ( $tutos[massupdate] == 1 ) {
           echo " <td rowspan=\"". $rs ."\" align=\"center\">\n";
           if ( $c->mod_ok() ) {
             echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $c->id ."\">\n";
           } else {
             echo "-\n";
           }
           echo "</td>\n";
         }
         echo $this->OverviewRowEnd($a);
       }
       unset($c);
     }
     echo "</tbody>\n";

     echo $this->list_navigation($this->link1,2 +  $tutos[massupdate],$this->start,$a,$n);
     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(2);
       echo sprintf($lang['withmarked'],$lang['Companies']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option VALUE=\"-2\">". $lang['Delete'] ."</option>\n";
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(1);
     }

     echo $this->OverviewTableEnd();
	 echo $this->actionformEnd("company_overview.php");
     $this->result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $c = new company($this->dbconn);
         $c->read($val);
         if ( $c->id != $val ) {
           continue;
	     }
         if ( $c->del_ok() ) {
           $msg .= sprintf($lang['CompanyDelInfo'], $c->getFullName()) ."<br>";
           $msg .= $c->delete();
	     } else {
           $msg .= $c->getLink() .": ". sprintf($lang['Err0023'],$lang[$c->getType()]) ."<br>\n";
	     }
         unset($c);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['CompanyOverview'];

     $this->link1 = "company_overview.php";
     $this->link2 = "company_overview.php";

     $q = "SELECT * FROM ". $this->dbconn->prefix ."companies";
     $pre = "WHERE";

     if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $q .= " ".  $pre ." ". $this->dbconn->Like("name",$_GET['name']);
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
       $this->link2 = addUrlParameter($this->link2,"name=". UrlEncode($_GET['name']));
     }

     check_dbacl( $q, $this->user->id);

     # sorting
     $xxx = "";
     order_parse($q,$this->link1,$xxx,$xxx,"name");

     $this->result = $this->dbconn->Exec($q);

     if ( 0 == $this->result->numrows()) {
       $this->redirect = "address_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     } else if ($this->result->numrows() == 1) {
       $c = new company($this->dbconn);
       $c->read_result($this->result,0);
       $this->redirect =  "company_show.php?id=".$c->id;
       $this->result->free();
	 }
     # menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array( url => "company_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['CompanyCreateInfo'],
                   category => array("company","new","obj")
                 );
       $this->addMenu($x);
	 }
   }
 }

 $l = new company_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: company_overview.php,v 1.40.2.1 2003/10/01 09:33:45 gokohnert Exp $
    $Author: gokohnert $
-->
