<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module acl_show
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('acl','show');

 /**
  * display  permissions
  */
 class acl_show extends layout {
   /**
    * Show an ACL
    */
   Function show($min, $max) {
     global $lang;

     $acls = array();

     @reset ($this->obj->acl);
     while ( list ($i,$f) = @each ($this->obj->acl) ) {
       if ( ($f < $max) && ($f >= $min) ) {
         if ( $i == 0 ) {
	   $acls[] =  array('name' => $lang['everybody']);
           continue;
         }

	 $pre = "";
         $x = getObject($this->dbconn,$i);
         if ( $x->gettype() == "team" ) {
           $pre .= $lang['team'] ." ";
         }

	 $acls[] = array('name'  => $pre . $x->getFullName(),
			 'title' => $x->getFullName(),
			 'link'  => $x->getUrl());
         unset($x);
       }
     }
     return $acls;
   }

   /**
    * infos
    */
   Function info() {
     global $lang, $tutos;

     $this->assign('title', sprintf($lang['AclDetailI'],
				    $lang[$this->obj->getType()] ." ".
				    myentities($this->obj->getFullName())));

     $this->assign('ACLread',   $lang['ACLread']);
     $this->assign('ACLuse',    $lang['ACLuse']);
     $this->assign('ACLmodify', $lang['ACLmodify']);
     $this->assign('ACLdelete', $lang['ACLdelete']);

     $this->assign('seeok', $this->show($tutos[seeok], $tutos[useok]));
     $this->assign('useok', $this->show($tutos[useok], $tutos[modok]));
     $this->assign('modok', $this->show($tutos[modok], $tutos[delok]));
     $this->assign('delok', $this->show($tutos[delok], 99));

     $this->template('acl_show');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg, $lang, $current_user;

     $this->name = $lang['AclDetail'];

     if ( ! isset($_GET['id']) ) {
       $msg .= "Missing ID";
       $this->stop = true;
       return;
     }
     $id = $_GET['id'];
     $this->obj = getObject($this->dbconn,$id);

     if ( $this->obj == -1) {
       $msg .= sprintf($lang['Err0040'],"Object");
       $this->stop = true;
     } else if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0023'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     // Menu
     if ( ($this->obj->id > 0) && 
	  ($current_user->isadmin() || $this->obj->del_ok()) ) {
       $x = array('url'   => "acl_new.php?id=".$this->obj->id,
		  'text'  => $lang['AclModify'],
		  'info'  => sprintf($lang['AclModifyI'],
				     $this->obj->getFullName()),
		  'image' => 'modify',
		  'category' => array("obj"));
       $this->addMenu($x);
     }
   }
 }

 $l = new acl_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: acl_show.php,v 1.18.2.4 2005/01/11 14:44:28 tapoueh Exp $
    $Author: tapoueh $
-->
