<?php
/**
 * Copyright 2003 by Gero Kohnert
 *
 * create a new product or modify an existing one
 *
 * @modulegroup url
 * @module url_select
 * @package url
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('team','select');

 /**
  * search for a team
  */
 class team_select extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $this->assign();

     $this->assign('action', 'team_overview.php');
     $this->assign('title', $lang['SearchForTeam']);

     $this->assign('name',
		   array('id'    => 'name',
			 'label' => $lang['TeamName'],
			 'value' => ""));

     $this->assign('search',
		   array('label' => $lang['Search'],
			 'title' => $lang['SearchForTeam']));
     
     $this->assign('info', $lang['ProdSelInfo']);
     
     $this->template('team_select');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['TeamSearch'];

     if ( ! $this->user->feature_ok(useteams,PERM_SEL) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     if ( $this->user->feature_ok(useteams,PERM_NEW) ) {
       $x = array('url'   => "team_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['TeamCreateI'],
		  'image' => 'teams',
                  'category' => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new team_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_select.php,v 1.4.2.1 2004/08/03 15:39:32 tapoueh Exp $
    $Author: tapoueh $
-->
