<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * @modulegroup user
 * @module user_overview
 * @package user
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';
 include_once 'task.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("user","overview");

 /**
  * show a overview of user accounts
  */
 class user_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;


     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }

     $this->assign('action', "user_overview.php");
     $this->assign('massupdate', $tutos[massupdate]);

     // Overview Table Header
     $headers = array();
     $headers[] = array('label' => $lang['User']);
     $headers[] = array('label' => $lang['UserLastSeen']);
     $headers[] = array('label' => $lang['UserLastHost']);
     $headers[] = array('label' => $lang['UserDisabled']);
     $headers[] = array('label' => $lang['UserLanguage']);
     $headers[] = array('label' => $lang['UserTimezone']);

     $this->assign('headers', $headers);
     $this->assign('nb_cols', count($headers) + 1);
     $this->assign('inner_cols', count($headers) - 1);

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     $this->assign('prev_start', $a == 0 ? $a : $a - $tutos[maxshow]);
     $this->assign('next_start', $end);

     $this->assign('NavBack',         $lang['NavBack']);
     $this->assign('NavNext',         $lang['NavNext']);

     $this->assign('nb_user', $n);
     $this->assign('astart', $a);
     $this->assign('aend',   $end > $n ? $n : $end);
     $this->assign('user_per_page', $tutos[maxshow]);

     // Generate direct links to page results
     $nb_pages   = ceil($n / $tutos[maxshow]);
     $direct_nav = array();
     for($i=0; $i < $nb_pages; $i++)
       $direct_nav[] =
	 array('label'  => $i + 1,
	       'astart' => $i * $tutos[maxshow],
	       'title'  => sprintf($lang['pageof'], $i+1, $nb_pages));

     $this->assign('direct_nav', $direct_nav);

     $users = array();

     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $f = new tutos_user($this->dbconn);
       $uid = $result->get($a, "id");
       $f->read($uid,1);
       $a++;
       if ( ! $f->see_ok() ) {
         continue;
       }

       $disabled = $f->disabled == 1 ? $lang['yes'] : $lang['no'];

       $users[] = array('id'      => $f->uid,
			'login'   => $f->login,
			'link'    => "user_new.php?uid=".$f->uid,
			'title'   => $f->getFullName(),
			'seen'    => $f->last_seen->getDateTime(),
			'host'    => $f->last_host,
			'disable' => $disabled,
			'lang'    => $f->lang,
			'tz'      => $f->tz );
       unset ($f);
     }
     $this->assign('users', $users);

     if ( $tutos[massupdate] == 1 ) {

       $this->assign("marked", sprintf($lang['withmarked'],$lang['Users']));

       $actions = array();
       $actions[-1] = $lang['ActionNil'];
       $actions[-2] = $lang['Delete'];
       $actions['enable'] = sprintf($lang['SetTo'],
				   $lang['UserDisabled'], $lang['no']);
       $actions['disable'] = sprintf($lang['SetTo'],
				    $lang['UserDisabled'], $lang['yes']);
       $actions[-4] = $lang['AclModify'];

       $this->assign('actions', $actions);
       $this->assign('Enter',   $lang['Enter']);
     }

     $this->template('user_overview');
   }

   /**
    * navigation
    */
   Function navigate() {
   }

   /**
    * action
    */
   Function action() {
     global $msg,$tutos,$lang;

     if ( $this->user->admin == 0 ) {
       return;
     }

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $b = new tutos_user($this->dbconn);
         $b->read($val,2);
         if ( $b->uid != $val ) {
           $msg .= $b->uid ." != ". $val ."<br>";
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= $lang['Delete'] ."&nbsp;". $b->login ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]);
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == 'enable' ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $b = new tutos_user($this->dbconn);
         $b->read($val,2);
         if ( $b->uid != $val ) {
           $msg .= $b->uid ." != ". $val ."<br>";
           continue;
         }
         if ( $b->mod_ok() ) {
           $msg .= $lang['UserDisable'] ."&nbsp;". $b->login ."<br>";
           $b->setDisabled(0);
           $msg .= $b->save();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0024'],$lang[$b->getType()]);
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == 'disable' ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $b = new tutos_user($this->dbconn);
         $b->read($val,2);
         if ( $b->uid != $val ) {
           $msg .= $b->uid ." != ". $val ."<br>";
           continue;
         }
         if ( $b->mod_ok() ) {
           $msg .= $lang['UserDisabled'] ."&nbsp;". $b->login ."<br>";
           $b->setDisabled(1);
           $msg .= $b->save();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0024'],$lang[$b->getType()]);
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['UserOverview'];

     if ( $this->user->admin == 0 ) {
       $msg .= "<span class=\"warn\">Only admins are allowed to see this</span><br>\n";
       if ( $tutos[demo] == 1 ) {
         $msg .= "<span class=\"warn\">exceptionally enabled for this demo</span><br>\n";
       } else {
         $this->stop = true;
       }
     }

     $this->link1 = "user_overview.php";
     $this->link2 = "user_overview.php";
     $this->q = "SELECT ". $this->dbconn->prefix ."people.*,id as u_id from ". $this->dbconn->prefix ."people";

     # sorting
     $xxx = "";
     order_parse($this->q,$this->link1,$xxx,$xxx,"login");
     
     $x = array('url'   => "user_new.php",
                'text'  => $lang['NewEntry'],
                'info'  => $lang['UserCreate'],
		'image' => 'new',
                'category' => array("user","new","obj")
               );
     $this->addMenu($x);

     web_StackStartLayout($this,"user_overview.php","user_overview.php?".$_SERVER['QUERY_STRING']);
   }
 }

 $l = new user_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: user_overview.php,v 1.24.2.1 2004/09/06 16:25:13 tapoueh Exp $
    $Author: tapoueh $
-->
