{* BugTracking Migration template *}
{* $Id: migration.tpl,v 1.1.2.3 2004/10/19 16:11:07 tapoueh Exp $ *}

<!-- bug_migration start -->
{include file="classic/js/mass_update.tpl"}

<table class="overview">
<thead>
<tr>
  <th colspan="2">Bugs</th>
</tr>
</thead>

<tfoot>
<tr>
  <td align="right">
    {$astart} - {$aend} /&nbsp;{$nb}
  </td>
  <td align="center">
   {include file="classic/navbar.tpl"}
  </td>
</tr>
</tfoot>

<tbody>
{foreach from=$bugs item=b}
<tr style="padding-top: 15px;">
 <td valign="top">
  <table style="width: 100%;">
   <tr><td class="desc">{$Bug}</td>           <td>{$b.id}</td></tr>
   <tr><td class="desc">{$Bug}</td>           <td>{$b.name}</td></tr>
   <tr><td class="desc">{$BugShort}</td>      <td>{$b.short}</td></tr>
   <tr><td class="desc">{$BugReference}</td>  <td>{$b.product_id}</td></tr>
   <tr><td class="desc">{$BugClass}</td>      <td>{$b.class}</td></tr>
   <tr><td class="desc">{$BugState}</td>      <td>{$b.state}</td></tr>
   <tr><td class="desc">{$BugAssignedTo}</td> <td>{$b.solver}</td></tr>
   <tr><td class="desc">{$Date}</td>          <td>{$b.solvedate}</td></tr>
   <tr><td class="desc">{$BugCreator}</td>    <td>{$b.creator}</td></tr>
   <tr><td class="desc">{$Date}</td>          <td>{$b.creation}</td></tr>
  </table>
 </td>
 <td valign="top">
{if $b.summary != ""}
{strip}
<pre style="background-color: #CCCCCC;">
{$b.summary|wordwrap:80:"\n":true}
</pre>
{/strip}
{strip}
<pre style="background-color: #CCCCFF;">
{$b.description|wordwrap:80:"\n":true}
</pre>
{/strip}
{else}
{strip}
<pre style="background-color: #CCCCCC;">
{$b.description|wordwrap:80:"\n":true}
</pre>
{/strip}
{/if}

<div style="margin-left: 25px; font-type: mono;">
{foreach from=$b.hist item=h}
<p style="border-top: 1px solid black; color: green;">
[{$h.id} -> {$h.bugid}] - <b>{$h.creation}</b> : {$h.creator}
</p>

{* For old bugs (with summary) don't show the same desc twice *}
{if $b.summary == ""}
{strip}
<pre style="background-color: #CCCCCC;">
{$h.description|wordwrap:80:"\n":true}
</pre>
{/strip}
{/if}

<table style="border-top: 1px dashed black; width: 100%;">
{foreach from=$h.changeset key=k item=v}
<tr>
{if is_array($v)}
  <td class="desc">{$k}</td>
  {foreach from=$v item=vs}
  <td style="margin-right: 2em;">{$vs}</td>
  {/foreach}
{else}
  <td class="desc" valign="top">{$k}</td>
  <td colspan="2" valign="top">
<pre style="background-color: #DDDDDD;">{$v|wordwrap:80:"\n":true}</pre>
  </td>
{/if}
</tr>
{/foreach}
</table>

{/foreach}
 </td>
</tr>
{/foreach}
</tbody>

</table>
<!-- bug_migration stop -->