<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * send a new mail
 *
 * @modulegroup mail
 * @module mail_ins
 * @package mail
 */ 
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("mail","ins");

 $msg = "";
 if ( ! isset($_POST['gotourl']) ) {
   $gotourl = "mytutos.php";
 } else {
   $gotourl = $_POST['gotourl'];
 }
 $m = new mail($current_user);
 $m->setFrom($current_user);

 $m->setSubject(StripSlashes($_POST['subject']));
 $gotourl = addUrlParameter($gotourl,"subject=".  UrlEncode(StripSlashes($m->subject)),true);

 $m->from->read_locs_data();
 $found = 0;
 if (isset($_POST['from'])) {
   $t = split(",",$_POST['from']);
   if ( isset($m->from->location) ) {
     @reset($m->from->location);
     while( list ($i,$f) = @each ($m->from->location)) {
       if ( $f->id == $t[1] ) {
         if ( $t[0] == 1 ) {
           $from = $f->email_1;
           $found = 1;
         }
         if ( $t[0] == 2 ) {
           $from = $f->email_2;
           $found = 1;
         }
       }
     }
   }
 }
 if ($found == 0 ) {
   $msg .= $lang['Err0029'];
 } else {
   $m->setFromTxt($from);
   # bcc will only work with sendmail not with smtp ;-(
   $m->addHeader("Bcc","<".$from.">");
 }


 if (isset($_POST['reply'])) {
   $gotourl = addUrlParameter($gotourl,"reply=". $_POST['reply'],true);
 }

 # Read the old mail if given
 if (isset($_POST['mid'])) {
   $gotourl = addUrlParameter($gotourl,"mid=". $_POST['mid'],true);
   $gotourl = addUrlParameter($gotourl,"mno=". $_POST['mno'],true);
   loadmodule('mailbox');
   $mbox = new mailbox($dbconn);
   $mbox->read($_POST['mid']);
   if ( isset($_POST['mpath']) ) {
     $mbox->setPath(Base64_Decode($_POST['mpath']));
     $gotourl = addUrlParameter($gotourl,"mpath=". $_POST['mpath'],true);
   }
   $mbox->open();
   $m2 = new mail($current_user);
   $m2->init_by_phpimap($mbox->mbox,imap_msgno($mbox->mbox,$_POST['mno']),false);
   $mbox->close();

   # add a in reply/reference id build by the message-id
   foreach ($m2->hdr as $i) {
     if (eregi("^Message-ID:(.*)",$i,$reg)) {
	   $m->addHeader("In-Reply-To",$reg[1]);
	 }
   }
   if ($m2->references != "") {
     $m->addHeader("References",$m2->references);
   }
 }
 if (isset($_POST['fid'])) {
   $gotourl = addUrlParameter($gotourl,"fid=". $_POST['fid'],true);
   $file = new tutos_file($dbconn);
   $file->read($_POST['fid']);
   $m2 = new mail($current_user);
   $m2->init_by_file_obj($this->file,false);
   # add a in reply/reference id build by the message-id
   foreach ($m2->hdr as $i) {
     if (eregi("^Message-ID:(.*)",$i,$reg)) {
	   $m->addHeader("In-Reply-To",$reg[1]);
	 }
   }
   if ($m2->references != "") {
     $m->addHeader("References",$m2->references);
   }
 }


 if (isset($_POST['to'])) {
   $t = split("[,;]",$_POST['to']);
   $gotourl = addUrlParameter($gotourl,"to[]=". UrlEncode(StripSlashes($_POST['to'])),true);
   for ($j = 0; $j < count($t); $j++) {
     $m->addTo(StripSlashes($t[$j]));
   }
 }  

 // team members are sent in bcc
 if (isset($_POST['toid'])) {
   $gotourl = addUrlParameter($gotourl,"toid=". $_POST['toid'],true);
   $to = getObject($dbconn,$_POST['toid']);
   if ( $to->getType() == "team" ) {
     $m->addBcc($to);
   } else if ( $to->getType() == "product" ) {
     $to->readroles();
     foreach ($to->role as $role => $f) {
       if ( isset ($to->role[$role] ) && is_array ($to->role[$role]) ) {
         foreach($to->role[$role] as $i => $o) {
           $m->addTo($o);
         }
       }
     }
   } else if ( $to->getType() == "group" ) {
     $to->read_member();
     foreach( $to->member as $i => $o) {
       $m->addTo($o);
     }
   }
 }

 $t = split("[,;]",$_POST['cc']);
 $gotourl = addUrlParameter($gotourl,"cc[]=". UrlEncode(StripSlashes($_POST['cc'])),true);
 for ($j = 0; $j < count($t); $j++) {
   $m->addCc(StripSlashes($t[$j]));
 }
 $t = split("[,;]",$_POST['bcc']);
 if($t == ""){
   $gotourl = addUrlParameter($gotourl,"bcc[]=". UrlEncode(StripSlashes($_POST['bcc'])),true);
 }
 for ($j = 0; $j < count($t); $j++) {
   $m->addBcc(StripSlashes($t[$j]));
 }
 if (trim($_POST['body']) == "") {
   $msg .= "empty message not sent";
#   $msg .= "<br>". $m->getToAscii();
 }

 $m->addBody(strtr(ereg_replace("\r\n", "\n", StripSlashes($_POST['body'])), "\r", "\n"), "text/plain", "TUTOS", "", $lang['content_encoding']);

 $_SESSION['BODY'.strlen($m->body)] = Base64_Encode(StripSlashes($_POST['body']));
 $gotourl = addUrlParameter($gotourl,"bodyid=". strlen($m->body),true);


 if ( isset($HTTP_POST_FILES['file']) ) {
   $farr = $HTTP_POST_FILES['file'];
   if ( $farr != "none" && file_exists($farr['tmp_name']) && (filesize($farr['tmp_name']) > 0) ) {
     $fd = fopen ($farr['tmp_name'], "rb");
     $body = fread($fd, filesize($farr['tmp_name']));
     fclose($fd);
     $m->addBody($body,$farr['type'],"TUTOS Attachment",$farr['name']);
     $gotourl= addUrlParameter($gotourl,"filepath=". $farr['name'],true);
   }
 }

# loadlayout();
# $l = new layout($current_user);
# foreach ($m->hdr as $i) {
#   echo myentities($i)."<br>";
# }
# echo $m->info($l,"html",0);
# Fatal_Error($msg,$gotourl);
# die("ENDE:". $msg);

 if ( $msg == "" ) {
   $msg .= $m->send();
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);
 
 // bug when $gotourl is too long 
 if ( strlen($gotourl) > 2000 ){
   if ( ! isset($_POST['gotourl']) ) {
     $gotourl = "mytutos.php";
   } else {
     $gotourl = $_POST['gotourl'];
   }
#   $gotourl = addUrlParameter($gotourl,"msg=Mail sent.");
 }

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
/*
 *  CVS Info:  $Id: mail_ins.php,v 1.31.2.1 2004/04/14 17:39:10 tapoueh Exp $
 *  $Author: tapoueh $
 */
?>