<?php
/**
 * Copyright 2001 - 2004 by Gero Kohnert
 *
 * @modulegroup ADMIN
 * @module admin_show
 * @package BASE
 */
 include 'webelements.p3';
 include 'permission.p3';
 require_once 'db/table.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("admin","show");
 loadlayout();

 /**
  * FROM http://www.php.net/manual/en/function.session-set-save-handler.php
  */
 function unserialize_session($val)
 {
   // not entirely foolproof, but replace the pipe with something obscure
   $replacer = chr(254).chr(254).chr(254);
   $repRegex = '/(")([A-Za-z0-9_]*?)(\|)/';
   $val = preg_replace($repRegex,'$1$2'.$replacer,$val);

   // split the semi-serialized data into keys and values
   $splitRegex = '/([^;}][A-Za-z0-9_]*?)\|/';
   $splitArray = preg_split($splitRegex, $val, -1,
                              PREG_SPLIT_DELIM_CAPTURE);

   // remove offset 0 -- always empty
   array_shift($splitArray);

   // build a useful array
   $usefulArray = array();
   while ($var = array_shift($splitArray)) {
       $val = array_shift($splitArray);
       $val = str_replace($replacer, '|', $val);
       $usefulArray[$var] = unserialize($val);
   }
   return $usefulArray;
 }
 /* ---------------------------------------------------------------------------
  *
  */
 Function getTableCount($tbl,&$dbconn) {
   $q = "SELECT count(*) as c from ". $dbconn->prefix . $tbl;
   $r = @$dbconn->exec($q,0);
   if ( ($r == -1) || (1 != $r->numrows()) ) {
     return "";
   }
   $cnt = $r->get(0, "c");
   $r->free();
   return $cnt;
 }
 /* ---------------------------------------------------------------------------
  *
  */
 Function getinfo() {
   global $table, $dbconn;

   ksort($table);
   @reset($table);
   while ( list ($i,$f) = @each ($table) ) {
     $table[$i]['count'] = 0;
     $table[$i]['count'] = getTableCount($f[name],$dbconn);
   }
 }


 /**
  * display a admin page
  */
 class admin_show extends layout {
   Function SubTableStart() {
     return "<table width=\"100%\" class=\"single\" border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
   }
   Function SubTableEnd() {
     return "</table>\n";
   }
   /**
    *
    */
   Function login_info() {
     global $lang,$tutos;

     echo "<tr>\n";
     echo " <th colspan=\"6\">". menulink("user_overview.php",$lang['AdminLoginInfo'],$lang['AdminLoginInfo']) ."</th>\n";
     echo "</tr>\n";
     echo "<tr><td colspan=\"6\">\n";
     echo $this->SubTableStart();
     echo "<tr>\n";
     echo $this->orderHeader("", $lang['AdrName'],$this->link2);
     echo $this->orderHeader("login", $lang['User'],$this->link2);
     echo $this->orderHeader("last_seen", $lang['UserLastSeen'],$this->link2);
     echo $this->orderHeader("last_host", $lang['UserLastHost'],$this->link2);
     echo $this->orderHeader("disabled", $lang['UserDisabled'],$this->link2);
     echo "</tr>\n";

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     $a = 0;
     $line = 1;
     while ( ($a < $n) && ( $a < $tutos[maxshow])) {
       echo $this->OverviewRowStart($line);
       $adr = new tutos_user($this->dbconn);
       $uid = $result->get($a, "id");
       $adr->read($uid,1);
       echo " <td colspan=\"1\">". $adr->getLink() ."&nbsp;</td>";
       echo " <td colspan=\"1\" align=\"right\">". makelink("user_new.php?uid=".$uid ,$result->get($a, "login")) ."</td>";
       $ls = $result->getDateTime($a, "last_seen");
       echo " <td colspan=\"1\">". $ls->getLinkDateTime() ."</td>";
       echo " <td colspan=\"1\">&nbsp;". $result->get($a, "last_host") ."</td>";
       echo " <td align=\"center\">". ($adr->disabled == 0 ? $lang['no']:$lang['yes']) ."</td>";
       echo $this->OverviewRowEnd($line++);
       unset($adr);
       $a++;
     }
     $result->free();
     echo $this->SubTableEnd();
     echo "</td></tr>\n";
   }
   /**
    *
    */
   Function sessions_info() {
     global $lang,$tutos;

     $n = new DateTime();
     $ts = $n->getTimeStamp();

     $handle = opendir($tutos[sessionpath]);
     if (! $handle ){
       return;
     }

     # Sessions
     echo "<tr>\n";
     echo " <th colspan=\"6\">Sessions</th>\n";
     echo "</tr>\n";
     echo "<tr><td colspan=\"6\">\n";
     echo $this->SubTableStart();
     echo "<tr>\n";
     echo $this->orderHeader("", $lang['AdrName'],"",1);
     echo $this->orderHeader("", "Path","",1);
     echo $this->orderHeader("", "Server","",1);
     echo $this->orderHeader("", $lang['UserLastSeen'],"",1);
     echo $this->orderHeader("", $lang['UserLastHost'],"",1);
     echo $this->orderHeader("", "Client Browser","",1);
     echo $this->orderHeader("", "Kill Session","",1);
     echo "</tr>\n";
     $line = 0;
     while (false !== ($file = readdir($handle))) { 
       if ( ! ereg("^sess_",$file) ) {
         continue;
       }
       $filename =  $tutos[sessionpath] ."/". $file;
       if ( filesize($filename) == 0 ) {
         continue;
       }
       if ( ! is_readable($filename) ) {
         continue;
       }
       $x = fopen($filename,'ro');
       $contents = fread ($x, filesize ($filename));
       fclose($x);
       $data = unserialize_session($contents);

       if (!isset($data['userid'])) {
         continue;
       }
       if (!isset($data['username'])) {
         continue;
       }
       if (!isset($data['path'])) {
         $data['path'] ="?";
       }
       if (!isset($data['client'])) {
         $data['client'] ="?";
       }
       if (!isset($data['server'])) {
         $data['server'] ="?";
       }
       if ($data['dbnr'] != $this->dbconn->db->id) {
         continue;
       }
       echo $this->OverviewRowStart($line);
       echo "<td colspan=\"1\">". makelink("address_show.php?id=".$data['userid'],$data['username']) ."</td>\n";
       echo "<td colspan=\"1\">". $data['path'] ."</td>\n";
       echo "<td colspan=\"1\">". $data['server'] ."</td>\n";
       echo "<td colspan=\"1\" align=\"right\">". ($ts - $data['lastseen']) ." seconds ago</td>\n";
       echo "<td colspan=\"1\">". $data['lasthost'] ."</td>\n";
       echo "<td colspan=\"1\">". $data['client'] ."</td>\n";
       $u= addUrlParameter($this->link2,"action=kill");
       $u= addUrlParameter($u,"mark=".$file);
       echo "<td colspan=\"1\" align=\"center\">&nbsp;". makelink($u,"kill") ."</td>\n";
       echo $this->OverviewRowEnd($line++);
#       print_r ($data);
     }
     echo $this->SubTableEnd();
     echo "</td></tr>\n";
     closedir($handle); 
   }
   /**
    *
    */
   Function info() {
     global $lang,$tutos,$table;

     $table = array();
     @require("db/table.pinc");

     $this->link2 = "admin_show.php";
     if ( ! $this->user->isAdmin() ) {
       echo $this->error("Only admins are allowed to see this");
       if ( $tutos[demo] == 1 ) {
         echo $this->error("exceptionally enabled for this demo");
       } else {
         return;
       }
     }
     if ($tutos[useacl] == 1) {
       $url['acl'] = "acl_overview.php";
     }
     $url['teams'] = "team_overview.php";
     $url['addresses'] = "address_overview.php";
     $url['products'] = "product_overview.php";
     $url['timetrack'] = "timetrack_select.php";
     $url['calendar'] = "app_select.php";
     $url['companies'] = "company_overview.php";
     $url['tutos_dbs'] = "database_overview.php";
     $url['history'] = "history_show.php";
     $url['messages'] = "message_overview.php";
     $url['people'] = "user_overview.php";

     getinfo();
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"6\">". $lang['AdminDBInfo'] ." : ". $this->dbconn->db->alias ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBName']);
     echo $this->showdata($this->dbconn->db->getLink($this->dbconn->db->name),2);
     echo $this->showfield($lang['AdminDBUser']);
     echo $this->showdata($this->dbconn->db->user,2);
     echo "</tr>\n";

     echo "<tr>\n";
     if ( $this->dbconn->gettype() == "Oracle" ) {
       echo $this->showfield($lang['AdminDBHome']);
       echo $this->showdata($this->dbconn->db->home,5);
     } else {
       echo $this->showfield($lang['AdminDBHost']);
       echo $this->showdata($this->dbconn->db->host,2);
       if ( $this->dbconn->gettype() == "Postgres" ) {
         echo $this->showfield($lang['AdminDBPort']);
         echo $this->showdata($this->dbconn->db->port,2);
       } else {
         echo " <td colspan=\"3\">&nbsp;</td>\n";
       }
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBInfo']);
     echo $this->showdata($this->dbconn->moreinfo(),6);
     echo "</tr>\n";

     # The baseurl for this installation
     echo "<tr>\n";
     echo $this->showfield("BaseURL");
     echo $this->showdata(makelink(getBaseUrl(true),getBaseUrl(true)),6);
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>". $lang['AdminDBCount'] ."</th>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>". $lang['AdminDBCount'] ."</th>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>". $lang['AdminDBCount'] ."</th>\n";
     echo "</tr>\n";
     @ksort($table);
     $c = 0;
     foreach ($table as $i => $f) {
       if ( $c == 0 ) {
         echo "<tr>\n";
       }
       if ( isset($url[$f[name]]) ) {
         echo " <td align=\"right\">". $this->dbconn->prefix . makelink($url[$f[name]],$f[name],$f[Desc]) ."</td>";
       } else {
         echo " <td align=\"right\">". $this->dbconn->prefix . $f[name] ."</td>";
       }
       echo " <td align=\"right\">". $f['count'] ."</td>";
       if ( $c == 2 ) {
         echo "</tr>\n";
         $c = 0;
       } else {
         $c++;
       }
     }
     if ($c != 0) {
       echo " <td colspan=\"". (3 - $c) * 2 ."\">&nbsp;</td></tr>\n";
     }

     echo "<tr>\n";
     echo " <th colspan=\"4\">Known Modules</th>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>" .$lang['AdminDBCount'] ."</th>\n";
     echo "</tr>\n";
     $line = 0;
     foreach ($tutos[modules] as $i => $f) {
       echo $this->OverviewRowStart($line);
       $table = array();
       echo " <td valign=\"top\" align=\"left\">";
       if ($tutos[$f['perm']] == 0) {
         echo "<strike>\n";
       }
       if ( isset ($f['overview']) ) {
         echo makelink($f['overview'],$f[name]) ."</td>\n";
       } else {
         echo $f[name];
       }
       if ($tutos[$f['perm']] == 0) {
         echo "</strike>\n";
       }
       echo "</td>\n";
       echo " <td valign=\"top\" colspan=\"2\" align=\"left\">". $f[Desc] ."</td>\n";

       if (isset($f[file])) {
         if (file_exists(dirname($tutos['base'] ."/". $tutos[modules][$i][file]) ."/mtable.pinc") ) {
           @include dirname($tutos['base'] ."/". $tutos[modules][$i][file]) ."/mtable.pinc";
         }
         echo " <td valign=\"top\" align=\"left\">". $f[file] ."</td>\n";
       } else {
         echo " <td valign=\"top\" align=\"left\">&nbsp;</td>\n";
       }
       echo " <td align=\"right\">&nbsp;";
       @reset($table);
       $pre = "";
       while ( list ($i2,$f2) = @each ($table) ) {
         echo $pre. $this->dbconn->prefix . $f2[name];
         $pre = "<br>\n";
       }
       echo "</td>\n";
       echo " <td align=\"right\">&nbsp;";
       @reset($table);
       $pre = "";
       while ( list ($i2,$f2) = @each ($table) ) {
         echo $pre . getTableCount($f2[name],$this->dbconn);
         $pre = "<br>\n";
       }
       echo "</td>\n";
       echo $this->OverviewRowEnd($line++);
     }


     $this->login_info();
     $this->sessions_info();

     echo $this->DataTableEnd();
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * action
    */
   Function action() {
     global $msg,$lang,$tutos;

     if ( $_GET['action'] == "kill" ) {
	   $file = $_GET['mark'];
       if ( ! ereg("^sess_",$file) ) {
         return;
       }
       $filename =  $tutos[sessionpath] ."/". $file;
       if ( filesize($filename) == 0 ) {
         return;
       }
       if ( ! is_readable($filename) ) {
         return;
       }
       $x = fopen($filename,'ro');
       $contents = fread ($x, filesize ($filename));
       fclose($x);
       $data = unserialize_session($contents);

       if (!isset($data['userid'])) {
         return;
       }
       if (!isset($data['username'])) {
         return;
       }
	   unlink($filename);
       $msg .= "Session for ". $data['username'] ." killed";
     }
   }
   /**
    * preparation
    */
   Function prepare() {
     global $tutos,$lang;

     $this->name = $lang['AdminShow'];
     $this->q = "SELECT * from ". $this->dbconn->prefix ."people WHERE last_seen is not null";
     # sorting
     $xxx = "";
     order_parse($this->q,$xxx,$xxx,$xxx,"last_seen DESC");


     $x = array( url => "user_new.php",
                 text => $lang['UserCreate'],
                 info => $lang['UserCreate'],
                 category => array("user","new")
               );
     $this->addMenu($x);
     if ($tutos[useacl] == 1) {
       $x = array( url => "acl_overview.php",
                   text => $lang['ACLOverview'],
                   info => $lang['ACLOverview'],
                   category => array("admin")
                 );
     $this->addMenu($x);
     }
     if ($tutos[usesync] == 1) {
       $x = array( url => "admin_sync.php",
                   text => $lang['AdminDBSync'],
                   info => $lang['AdminDBSync'],
                   category => array("admin")
                 );
       $this->addMenu($x);
     }

     $x = array( url => "phpinfo.php",
                 text => "PHP - Info",
                 info => "PHP - Info",
                 category => array("admin")
               );
     $this->addMenu($x);
   }
 }
 session_write_close();
 $l = new admin_show($current_user);
 $l->display();
 $dbconn->close();
?>
<!--
    CVS Info:  $Id: admin_show.php,v 1.65.2.1 2004/04/14 17:39:08 tapoueh Exp $
    $Author: tapoueh $
-->
