<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_overview
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","overview");

 /**
  * show a overview of task for user / project
  */
 class task_overview extends layout {
   /**
    * free search
    */
   function select_by_name() {
     $this->parent->min_start = new DateTime();
     $this->parent->max_end = new DateTime(0);
     $this->parent->sum['volume'] = 0.0;
     $this->parent->sum['volume_done'] = 0.0;
     $q = "SELECT * from ". $this->dbconn->prefix ."tasks WHERE ";
     $q .= $this->dbconn->like("name", $this->search);
     $q .= " ORDER by s_start";
     $r = $this->dbconn->Exec($q);
     $n = $r->numrows();
     $a = 0;
     while ($a < $n) {
       $t = new task($this->dbconn);
       $t->read_result($r,$a);
       $t->readTimetrackSum();
       $this->parent->tasklist[$t->id] = &$t;
       $a++;

       $max_end = max($this->parent->max_end->ts,$t->s_end->ts);
       $min_start = min($this->parent->min_start->ts,$t->s_start->ts);
       $this->parent->min_start->setDateTimeTS($min_start);
       $this->parent->max_end->setDateTimeTS($max_end);
       $this->parent->sum['volume_done'] += $t->timetracksum;
       $this->parent->sum['volume'] += $t->volume;
	   unset($t);
	 }
   }

   /**
    * display the info
    */
   Function info() {
     global $lang, $tutos;

     if( $this->start->notime == 1) {
       $this->start = $this->parent->min_start;
       $this->end   = $this->parent->max_end;
     }

     $this->assign('form_action', 'task_overview.php');
     $this->assign('id', $this->parent->id);
     $this->assign('TaskSummary', $lang['TaskSummary']);

     /**
      * the date filter
      */
     $this->assign_date($lang['DateTimeFrom'], "start", $this->start);
     $this->assign_date($lang['DateTimeTill'], "end", $this->end);
     $this->assign('InputOk',   $lang['InputOk']);

     switch( $this->parent->getType() ) {
     case "address":
     case "user":
       $image = "user";
     break;
     
     case "product":
       $image = "projects";
     break;

     case "team":
       $image = "teams";
     break;
     
     default:
       $image = $parent->type;
     break;
     }

     $this->assign('parent',
		   array('type'  => $this->parent->getType(),
			 'name'  => $this->parent->getFullName(),
			 'title' => $this->parent->getFullName(),
			 'link'  => $this->parent->getUrl(),
			 'image' => $image));

     // Lang assigns for headers
     $this->assign('TaskOverview', $lang['TaskOverview']);
     $this->assign('forphrase',    $lang['forphrase']);
     $this->assign('hours',        $lang['hours']);
     $this->assign('Product',      $lang['Product']);
     $this->assign('TaskName',     $lang['TaskName']);
     $this->assign('TaskState',    $lang['TaskState']);
     $this->assign('TaskVolume',   $lang['TaskVolumeLabel']);
     $this->assign('TaskOverview', $lang['TaskOverview']);
     $this->assign('TaskWorker',   $lang['TaskWorker']);
     $this->assign('Completed',    $lang['Completed']);
     $this->assign('TaskS_Start',  $lang['TaskS_Start']);
     $this->assign('TaskS_End',    $lang['TaskS_End']);
     
     if( $this->search == "" )
       $this->assign('search', $this->parent->getFullName());
     else
       $this->assign('search', $this->search);

     /**
      * Get the task list
      */
     if ( $this->parent->getType() == "task" ) {
       $tasks = $this->parent->printRow($parent, 0, $this->fld,
					$this->start, $this->end,
					$this->state);
     }
     else {
       $tasks = array();

       foreach( $this->parent->tasklist as $i => $f ) {
	 $tmp = $this->parent->tasklist[$i]->printRow($this->parent, 0,
						      $this->fld,
						      $this->start,
						      $this->end,
						      $this->state);
	 if( count($tmp) > 0 )
	   $tasks[] = $tmp;
       }
     }
     $tasks = task::flatten_tasks($tasks);

     // Compute lengths of task element to be displayed
     $width = 200;
     $this->assign('width', $width);
     $limits = task::computeOverview($tasks, $width);

     // $this->debug($tasks);
     $this->assign('tasks', $tasks);
     $this->assign('withtimeline', $limits['withtimeline']);

     /**
      * We have to tell the template if the tasks are all before or
      * after current time (in the case we do not display the timeline).
      */
     if( ! $limits['withtimeline'] )
       if( $limits['t'] > $limits['max'] )
	 $this->assign('when', 'before');
       else
	 $this->assign('when', 'after');

     // Compute the sums of the volume of the tasks we're about to
     // display
     $volume = $volume_done = 0.0;
     $volume_todo = -1;
     foreach( $tasks as $i => $t ) {
       if( ! $t['logical'] ) {
	 $volume += $t['volume'];
	 $volume_done += $t['volume_done'];

	 // Don't sum up the volume todo if the task completion is 100%
	 if( $t['completed'] < 100 ) {
	   if( $t['volume_todo'] > -1 )
	     if( $volume_todo == -1 )
	       $volume_todo = $t['volume_todo'];
	     else
	       $volume_todo += $t['volume_todo'];
	 }
       }
     }

     if( $volume_todo == -1 )
       $completed = 100.0 * ( $volume_done / $volume );
     else
       $completed = 100.0 * ( $volume_done / 
			      ($volume_todo + $volume_done) );


     $start = new DateTime();  $end = new DateTime();
     $start->setDateTimeTS($limits['min']);
     $end->setDateTimeTS($limits['max']);

     $this->assign('start', array('label' => $lang['AppStart'],
				  'value' => $start->getDate()));

     $this->assign('end', array('label' => $lang['AppEnd'],
				'value' => $end->getDate()));

     $this->assign('volume', array('label' => $lang['TaskVolumeFull'],
				   'value' => $volume));

     $this->assign('volume_done', array('label' => $lang['TaskVolumeDone'],
					'value' => $volume_done));

     $this->assign('volume_todo', array('label' => $lang['TaskVolumeTodo'],
					'value' => $volume_todo));

     $this->assign('completed', array('label' => $lang['Completed'],
				      'value' => $completed));

     // Mass updating And Legend
     $options = $states = array();
     $options[-1] = $lang['ActionNil'];
     $options[-2] = $lang['Delete'];

     foreach( $lang['TaskStates'] as $i => $f ) {
       $options[$i] = sprintf($lang['SetTo'], $lang['TaskState'], $f);

       // We also prepare the legend data
       $states[$i] = $f;
     }

     // Adding the ability to mass update time slice
     $options['timeslice']   = $lang['Reschedule'];
     $options['timeslice_s'] = $lang['Reschedule_s'];
     $options['timeslice_e'] = $lang['Reschedule_e'];

     $this->assign('action', 
		   array('name'    => 'action',
			 'label'   => sprintf($lang['withmarked'],
					      $lang['Tasks']),
			 'options' => $options));

     $this->assign('states',  $states);
     $this->assign('Enter',   $lang['Enter']);
     $this->assign('InputOk', $lang['InputOk']);

     $this->template('task_overview');

   }

   /**
    * action
    */
   Function action() {
     global $msg, $lang;

     @reset($_REQUEST['mark']);

     switch( $_REQUEST['action'] ) {
     case -2:
       $this->dbconn->Begin("WORK");
       while( list($key, $val) = @each($_REQUEST['mark']) ) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           $msg .= "Unknown TASK ". $val ."<br>\n";
           continue;
         }
         if ( $p->del_ok() ) {
           $msg .= sprintf($lang['TaskDelete'], $p->getFullName()) ."<br>";
           $msg .= $p->delete();
         } else {
           $msg .= $p->getLink() .": ".  sprintf($lang['Err0023'],$lang[$p->getType()])."<br>\n";
         }
         unset($p);
       }
       $this->dbconn->Commit("WORK");
       break;

     case "timeslice":
       $arg = $_REQUEST['arg'];
       // control the given value
       if( !is_numeric($arg) ) {
         $msg .= sprintf($lang['Err0017'], $lang['Reschedule'])."<br>";
         break;
       }
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_REQUEST['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $start = $p->s_start;
           $end   = $p->s_end;
           $start->addDays($arg);
           $end->addDays($arg);
           $p->setSStart($start);
           $p->setSEnd($end);
           $msg .= $p->save();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()])."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;

     case "timeslice_s":
       $arg = $_REQUEST['arg'];
       // control the given value
       if( !is_numeric($arg) ) {
         $msg .= sprintf($lang['Err0017'], $lang['Reschedule'])."<br>";
         break;
       }
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_REQUEST['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $start = $p->s_start;
           $end   = $p->s_end;
           $start->addDays($arg);
           if( $start->getYYYYMMDD() <= $end->getYYYYMMDD() ) {
             $p->setSStart($start);
             $msg .= $p->save();
           } else {
             $msg .= $p->getLink() .": ".$lang['Err0002']."<br>\n";
           }
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()])."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;

     case "timeslice_e":
       $arg = $_REQUEST['arg'];
       // control the given value
       if( !is_numeric($arg) ) {
         $msg .= sprintf($lang['Err0017'], $lang['Reschedule'])."<br>\n";
         break;
       }
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_REQUEST['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $start = $p->s_start;
           $end   = $p->s_end;
           $end->addDays($arg);
           if( $start->getYYYYMMDD() <= $end->getYYYYMMDD() ) {
             $p->setSEnd($end);
             $msg .= $p->save();
           } else {
             $msg .= $p->getLink() .": ".$lang['Err0002']."<br>\n";
           }
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]) ."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;

     default:
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_REQUEST['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $msg .= $p->getLink() ." ". $lang['TaskState'] ." = ".  $lang['TaskStates'][$_REQUEST['action']] ."<br>";
           $msg .= $p->setState($_REQUEST['action']);
           $msg .= $p->save();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]) ."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;
     }

     /**
      * Now get back to the task_overview with its parameters properly
      * set
      */
     $params = array('id', 'name', 'state',
		     'start_d', 'start_m', 'start_y', 
		     'end_d', 'end_m', 'end_y');

     $gotourl = "task_overview.php";
     foreach( $params as $p ) {
       if( isset($_REQUEST[$p]) )
	 $gotourl = addUrlParameter($gotourl, $p."=".$_REQUEST[$p], true);
     }

     Header("Status: 302 Moved Temporarily");
     Header("Location: ". getBaseUrl() . $gotourl);
   }

   /**
    * Provide a task state legend
    */
   function legend() {
     global $lang;

     $this->assign("legend", $lang['legend']);
     $this->assign("TaskState", $lang['TaskState']);

     foreach( $lang['TaskStates'] as $i => $f ) {
       $states[$i] = $f;
     }
     $this->assign('states', $states);

     /**
      * Make up a filter array
      */
     $filter = $this->get_task_filter();
     // $this->debug($filter);
     $this->assign('filter', $filter);

     $this->template('task_overview_legend');
   }

   /**
    * navigate
    */
   Function navigate() {
     $this->menuprint('task');
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos; 

     $this->fld = "";
     $this->name = $lang['TaskOverview'];
     $this->start = new DateTime(0);
     $this->end = new DateTime(0);
     $this->search = "";
     $this->state = 0;
     $this->parent = -1;

     if ( ! $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }


     if ( isset($_REQUEST['id']) ) {
       if (false == is_numeric($_REQUEST['id'])) {
         $msg .= sprintf($lang['Err0012'],"id",$_REQUEST['id']);
	 $this->stop = true;
       }
       $this->parent = GetObject($this->dbconn,$_REQUEST['id']);
       if ($this->parent == -1) {
         $msg .= $lang['Err0048'];
         $this->stop = true;
         return;
       }
       //$this->addHidden("id",$this->parent->id);
       $this->name .= " : ". $this->parent->getFullName();

       if ( isset($_REQUEST['fld']) ) {
         $this->fld = $_REQUEST['fld'];
       }
       task_calc($this->parent);

       $x = task::getaddlink($this->user,$this->parent,$lang['NewEntry']);
       $x['image'] = 'new';
       $this->addMenu($x);
     }
     else if ( isset($_REQUEST['name']) ) {
       // Classical Search
       $this->search = $_REQUEST['name'];
       $this->parent = new tutos_base($this->dbconn);
       $this->fld = "worker";
       $this->select_by_name();
     }

     /**
      * State
      *
      * As in legend we add a filter and use generic mklink.tpl, the
      * state is to be found in $_REQUEST['xo']
      */
     if( isset($_REQUEST['xo']) ) {
       $_REQUEST['state'] = $_REQUEST['xo'];
     }

     if ( isset($_REQUEST['state']) ) {
       if (false == is_numeric($_REQUEST['state'])) {
         $msg .= sprintf($lang['Err0012'],"state",$_REQUEST['state']);
	 $this->stop = true;
       }
       $this->state = $_REQUEST['state'];
     }
     else
       $this->state = -1;
     
     $this->assign('state', $this->state);

     // Timerange Start
     if ( isset($_REQUEST['start']) ) {
       $this->start->setDateTime($_REQUEST['start']);
     }
     else {
       if( isset($_REQUEST['start_d']) ) {
         $this->start->setDateTimeF('start');
         $_SESSION['tasksearchfrom'] = $this->start->getYYYYMMDD();
       }
     }
     // Timerange End
     if ( isset($_REQUEST['end']) ) {
       $this->end->setDateTime($_REQUEST['end']);
     }
     else {
       if( isset($_REQUEST['end_d']) ) {
         $this->end->setDateTimeF('end');
         $_SESSION['tasksearchto'] = $this->end->getYYYYMMDD();
       }
     }

     // $this->debug($this->start);
     // $this->debug($this->end);

     // menu

     // The PNG Gantt functionality, using JpGraph Tools, to be installed
     if( $tutos[usejpgraph] ) {
       $x = array('url'   => "task_gantt.php?". $this->get_task_filter('url'),
                  'text'  => $lang['TaskGantt'],
		  'image' => 'gantt',
                  'info'  => $lang['TaskGantt'],
                  'category' => array("task","view")
                 );
       $this->addMenu($x);
     }

     if( $this->parent != -1  && ($this->name == "")
	 && $this->parent->getType() !=  "address" ) {
       $x = array('url'  => "task_overview.php?id=".$this->parent->id, 
                  'info' => sprintf($lang['TaskOverviewInfo'],
				    $this->parent->getFullName()),
                  'category' => array("task","view")
		  );

       $x['text'] = $lang['TaskOverview'];
       $this->addMenu($x);

       $x['text'] = $lang['TaskOverview'] ."++";
       $x['url'] = "task_overview.php?id=".$this->parent->id;
       switch( $this->parent->getType() ) {
       case "user":
       case "team":
         $x[url] .= "&amp;fld=product";
         break;
       default:
         $x[url] .= "&amp;fld=worker";
         break;
       }
       $this->addMenu($x);
     }

     web_StackStartLayout($this,
              "task_overview.php?id=".$this->parent->id,
              "task_overview.php?".$_SERVER['QUERY_STRING']);
   }
 }

 $l = new task_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
CVS Info:  $Id: task_overview.php,v 1.62.2.21 2005/04/12 10:29:57 tapoueh Exp $
 $Author: tapoueh $
 -->