(*
    Tux Commander - UConnectionManager - Connection manager dialog
    Copyright (C) 2004 Tomas Bzatek <tbzatek@users.sourceforge.net>
    Check for updates on tuxcmd.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)
unit UConnectionManager;

interface

uses
  glib2, gdk2, gtk2, pango, SysUtils, Types, Classes, GTKControls, GTKForms, GTKStdCtrls, GTKExtCtrls, GTKConsts, GTKView,
  GTKUtils, GTKDialogs, GTKPixbuf, GTKClasses,
  UCoreClasses;

type
  TFConnectionManager = class(TGTKDialog)
    TitleFrame: TGTKFrame;
    TitleLabel: TGTKLabel;
    TitleEventBox: TGTKEventBox;
    TitleIcon: TGTKImage;
    TitleHBox: TGTKHBox;
    ListView: TGTKListView;
    ListViewScrolledWindow: TGTKScrolledWindow;
    ListViewTable: TGTKTable;
    AddConnectionButton, EditButton, RemoveButton: TGTKImageButton;
    ButtonBox: TGTKVButtonBox;
    procedure FormCreate(Sender: TObject); override;
    procedure ListViewSelectionChanged(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; Key: Word; Shift: TShiftState; var Accept: boolean);
    procedure AddConnectionButtonClick(Sender: TObject);
    procedure EditButtonClick(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
    procedure ListViewDblClick(Sender: TObject; Button: TGDKMouseButton; Shift: TShiftState; X, Y: Integer; var Accept: boolean);
    procedure ListViewKeyDown(Sender: TObject; Key: Word; Shift: TShiftState; var Accept: boolean);
  private
    procedure FillList;
  end;

var
  FConnectionManager: TFConnectionManager;

implementation

uses ULocale, UCoreUtils, UConfig, UCore, UConnectionProperties, UVFSCore;

const Connect_Button_ID = integer(mbOK);


procedure TFConnectionManager.FormCreate(Sender: TObject);
var Column: TGTKTreeViewColumn;
begin
  SetDefaultSize(550, 450);
  Caption := LANGConnMgr_Caption;
  AddButton(LANGConnMgr_ConnectButton, Connect_Button_ID);
  Buttons := [mbClose];
  ShowSeparator := False;
  TitleEventBox := TGTKEventBox.Create(Self);
  TitleLabel := TGTKLabel.Create(Self);
  TitleLabel.Caption := Format('<span size="x-large" weight="ultrabold">%s</span>', [LANGConnMgr_OpenConnection]);
  TitleLabel.UseMarkup := True;
  TitleLabel.XAlign := 0;
  TitleLabel.XPadding := 0;
  TitleLabel.YPadding := 3;
  TitleEventBox.ControlState := csPrelight;
  TitleFrame := TGTKFrame.CreateWithoutLabel(Self);
  TitleFrame.ShadowType := stShadowOut;
  TitleIcon := TGTKImage.Create(Self);
  TitleIcon.SetFromStock('gtk-connect', isLargeToolbar);
  TitleHBox := TGTKHBox.Create(Self);
  TitleHBox.Homogeneous := False;
  TitleHBox.AddControlEx(TGTKEventBox.Create(Self), False, False, 5);
  TitleHBox.AddControlEx(TitleIcon, False, False, 0);
  TitleHBox.AddControlEx(TitleLabel, True, True, 10);
  TitleEventBox.AddControl(TitleHBox);
  TitleFrame.AddControl(TitleEventBox);
  ClientArea.AddControlEx(TitleFrame, False, True, 0);

  ListViewTable := TGTKTable.Create(Self);
  ListViewTable.BorderWidth := 7;
  ClientArea.AddControlEx(ListViewTable, True, True, 0);

  ListView := TGTKListView.CreateTyped(Self, False, [lcPointer, lcText, lcText]);
  ListView.OnKeyDown := ListViewKeyDown;

  ListView.RulesHint := True;
  ListView.ShowHeaders := True;
  Column := ListView.Columns.Add;
  Column.AddAttribute('text', 1);
  Column.Resizable := True;
  Column.FixedWidth := 200;
  Column.SizingMode := smFixed;
  Column.Caption := LANGConnMgr_NameColumn;
  Column.Clickable := True;
  Column.SortID := 1;
  Column := ListView.Columns.Add;
  Column.AddAttribute('text', 2);
  Column.Resizable := True;
  Column.SizingMode := smFixed;
  Column.Caption := LANGConnMgr_URIColumn;
  Column.Clickable := True;
  Column.SortID := 2;
  ListViewScrolledWindow := TGTKScrolledWindow.Create(Self);
  ListViewScrolledWindow.AddControl(ListView);
  ListViewScrolledWindow.HorizScrollBarPolicy := sbAutomatic;
  ListViewScrolledWindow.VertScrollBarPolicy := sbAutomatic;
  ListViewScrolledWindow.ShadowType := stShadowIn;

  AddConnectionButton := TGTKImageButton.Create(Self);
  AddConnectionButton.SetFromStock('gtk-add', isSmallToolbar);
  AddConnectionButton.Caption := LANGConnMgr_AddConnectionButtonCaption;
  AddConnectionButton.UseUnderline := True;
  AddConnectionButton.Tooltip := LANGConnMgr_AddConnectionButtonTooltip;
  EditButton := TGTKImageButton.Create(Self);
  EditButton.Caption := LANGConnMgr_EditButtonCaption;
  EditButton.UseUnderline := True;
  EditButton.Tooltip := LANGConnMgr_EditButtonTooltip;
  RemoveButton := TGTKImageButton.Create(Self);
  RemoveButton.SetFromStock('gtk-remove', isSmallToolbar);
  RemoveButton.Caption := LANGConnMgr_RemoveButtonCaption;
  RemoveButton.UseUnderline := True;
  RemoveButton.Tooltip := LANGConnMgr_RemoveButtonTooltip;
  
  ButtonBox := TGTKVButtonBox.Create(Self);
  ButtonBox.Spacing := 10;
  ButtonBox.AddControl(AddConnectionButton);
  ButtonBox.AddControl(EditButton);
  ButtonBox.AddControl(RemoveButton);

  ListViewTable.AddControlEx(0, 1, 3, 5, ListViewScrolledWindow, [taoExpand, taoFill], [taoExpand, taoFill], 0, 5);
  ListViewTable.AddControlEx(3, 2, 1, 3, ButtonBox, [taoShrink, taoFill], [taoShrink], 5, 5);
{  ListViewTable.AddControlEx(3, 2, 1, 1, AddConnectionButton, [taoShrink, taoFill], [taoShrink], 5, 5);
  ListViewTable.AddControlEx(3, 3, 1, 1, EditButton, [taoShrink, taoFill], [taoShrink], 5, 5);
  ListViewTable.AddControlEx(3, 4, 1, 1, RemoveButton, [taoShrink, taoFill], [taoShrink], 5, 5); }
//  ListViewTable.AddControlEx(3, 1, 1, 1, TGTKLabel.Create(Self), [taoShrink, taoFill], [taoExpand, taoFill], 0, 2);
  ListViewTable.AddControlEx(3, 5, 1, 1, TGTKLabel.Create(Self), [taoShrink, taoFill], [taoExpand, taoFill], 0, 2);


  FillList;
  ListView.OnSelectionChanged := ListViewSelectionChanged;
  ListView.OnDblClick := ListViewDblClick;
  ListView.SetFocus;
  if ListView.Items.Count > 0 then ListView.Items[ConfConnMgrActiveItem].SetCursor(0, False, False, 0, 0);
  ListViewSelectionChanged(Self);
  AddConnectionButton.OnClick := AddConnectionButtonClick;
  EditButton.OnClick := EditButtonClick;
  RemoveButton.OnClick := RemoveButtonClick;
  OnKeyDown := FormKeyDown;
end;

procedure TFConnectionManager.ListViewSelectionChanged(Sender: TObject);
begin
  try
    EditButton.Enabled := Assigned(ListView.Selected);
    RemoveButton.Enabled := Assigned(ListView.Selected);
    SetResponseSensitive(Connect_Button_ID, Assigned(ListView.Selected));
  except end;
end;

procedure TFConnectionManager.FormKeyDown(Sender: TObject; Key: Word; Shift: TShiftState; var Accept: boolean);
begin
  case Key of
    GDK_RETURN, GDK_KP_ENTER: if Assigned(ListView.Selected) then ModalResult := mbOK;
    GDK_ESCAPE: ModalResult := mbCancel;
  end;
end;

procedure TFConnectionManager.ListViewDblClick(Sender: TObject; Button: TGDKMouseButton; Shift: TShiftState; X, Y: Integer; var Accept: boolean);
begin
  if Assigned(ListView.Selected) then ModalResult := mbOK;
end;

procedure TFConnectionManager.ListViewKeyDown(Sender: TObject; Key: Word; Shift: TShiftState; var Accept: boolean);
begin
  case Key of
    GDK_Delete_Key: RemoveButtonClick(Sender);
  end;
end;

(********************************************************************************************************************************)
(********************************************************************************************************************************)
procedure TFConnectionManager.AddConnectionButtonClick(Sender: TObject);
var Item: TGTKListItem;
    ConnMgrItem: TConnMgrItem;
begin
  try
    FConnectionProperties := TFConnectionProperties.Create(Self);
    if FConnectionProperties.Run = mbOK then begin
      ConnMgrItem := TConnMgrItem.Create;
      with FConnectionProperties do begin
        ConnMgrItem.ConnectionName := NameEntry.Text;
        ConnMgrItem.URI := MakeURI(False);
        ConnMgrItem.ServiceType := Copy(ConnMgrItem.URI, 1, Pos('://', ConnMgrItem.URI) - 1);
        ConnMgrItem.Server := ServerEntry.Text;
        ConnMgrItem.Username := UserNameEntry.Text;
        ConnMgrItem.Password := PasswordEntry.Text;
        ConnMgrItem.TargetDir := TargetDirEntry.Text;
        ConnMgrItem.PluginID := '';
        if PluginOptionMenu.ItemIndex <> 0 then ConnMgrItem.PluginID := TVFSPlugin(PluginList[PluginOptionMenu.ItemIndex - 1]).VFSName;
      end;
      ConnectionMgrList.Add(ConnMgrItem);
      Item := ListView.Items.Add;
      Item.SetValue(0, ConnMgrItem);
      Item.SetValue(1, ConnMgrItem.ConnectionName);
      Item.SetValue(2, FConnectionProperties.MakeURI(True));
    end;
  finally
    FConnectionProperties.Free;
  end;
end;

procedure TFConnectionManager.EditButtonClick(Sender: TObject);
var Item: TGTKListItem;
    ConnMgrItem: TConnMgrItem;
    i: integer;
begin
  try
    Item := ListView.Selected;
    if Item = nil then Exit;
    ConnMgrItem := Item.AsPointer(0);
    if ConnMgrItem = nil then Exit;
    FConnectionProperties := TFConnectionProperties.Create(Self);
    FConnectionProperties.NameEntry.Text := ConnMgrItem.ConnectionName;
    FConnectionProperties.URIEntry.Text := ConnMgrItem.URI;
    FConnectionProperties.ServiceTypeOptionMenuChanged(Sender);
    //  Find the plugin by PluginID
    for i := 0 to PluginList.Count - 1 do
      if TVFSPlugin(PluginList[i]).VFSName = ConnMgrItem.PluginID then begin
        FConnectionProperties.PluginOptionMenu.ItemIndex := i + 1;
        Break;
      end;

    if FConnectionProperties.Run = mbOK then begin
      with FConnectionProperties do begin
        ConnMgrItem.ConnectionName := NameEntry.Text;
        ConnMgrItem.URI := MakeURI(False);
        ConnMgrItem.ServiceType := Copy(ConnMgrItem.URI, 1, Pos('://', ConnMgrItem.URI) - 1);
        ConnMgrItem.Server := ServerEntry.Text;
        ConnMgrItem.Username := UserNameEntry.Text;
        ConnMgrItem.Password := PasswordEntry.Text;
        ConnMgrItem.TargetDir := TargetDirEntry.Text;
        ConnMgrItem.PluginID := '';
        if PluginOptionMenu.ItemIndex <> 0 then ConnMgrItem.PluginID := TVFSPlugin(PluginList[PluginOptionMenu.ItemIndex - 1]).VFSName;
      end;
      Item.SetValue(1, ConnMgrItem.ConnectionName);
      Item.SetValue(2, FConnectionProperties.MakeURI(True));
    end;
  finally
    FConnectionProperties.Free;
  end;
end;

procedure TFConnectionManager.RemoveButtonClick(Sender: TObject);
var Item: TGTKListItem;
    ConnMgrItem: TConnMgrItem;
    i: integer;
begin
  Item := ListView.Selected;
  if Item = nil then Exit;
  ConnMgrItem := Item.AsPointer(0);
  if ConnMgrItem = nil then Exit;
  if Application.MessageBox(Format(LANGConnMgr_DoYouWantDelete, [Item.AsString(1)]),
                            [mbYes, mbNo], mbQuestion, mbYes, mbNo) = mbYes then
  begin
    if ConnectionMgrList.Count > 0 then
      for i := 0 to ConnectionMgrList.Count - 1 do
        if ConnectionMgrList[i] = ConnMgrItem then begin
          ConnectionMgrList.Delete(i);
          Break;
        end;
    ConnMgrItem.Free;
    ListView.Items.Delete(Item.Index);
  end;
end;

procedure TFConnectionManager.FillList;
var i: integer;
    Item: TGTKListItem;
    ConnMgrItem: TConnMgrItem;
begin
  ReadConnections;

  if ConnectionMgrList.Count > 0 then
    for i := 0 to ConnectionMgrList.Count - 1 do begin
      ConnMgrItem := ConnectionMgrList[i];
      Item := ListView.Items.Add;
      Item.SetValue(0, ConnMgrItem);
      Item.SetValue(1, ConnMgrItem.ConnectionName);
      Item.SetValue(2, ConstructURI(True, ConnMgrItem.ServiceType, ConnMgrItem.Server, ConnMgrItem.Username,
                                          ConnMgrItem.Password, ConnMgrItem.TargetDir));
    end;
  if (ConfConnMgrActiveItem < 0) or (ConfConnMgrActiveItem > ConnectionMgrList.Count) then
    ConfConnMgrActiveItem := 0;
end;




end.

