(*
    Tux Commander - USetPassword - Password prompt dialog
    Copyright (C) 2008 Tomas Bzatek <tbzatek@users.sourceforge.net>
    Check for updates on tuxcmd.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)
unit USetPassword;

interface

uses
  glib2, gtk2, pango, SysUtils, Types, Classes, GTKControls, GTKForms, GTKStdCtrls, GTKExtCtrls, GTKConsts, GTKView,
  GTKUtils, GTKDialogs, GTKPixbuf, GTKClasses;
  
type
  TFSetPassword = class(TGTKDialog)
    Label1, Label2: TGTKLabel;
    DialogIcon: TGTKImage;
    Entry: TGTKEntry;
    Table: TGTKTable;
    ShowPasswordCheckButton: TGTKCheckButton;
    procedure FormCreate(Sender: TObject); override;
    procedure FormKeyDown(Sender: TObject; Key: Word; Shift: TShiftState; var Accept: boolean);
    procedure ShowPasswordCheckButtonClick(Sender: TObject);
  end;

var
  FSetPassword: TFSetPassword;

implementation

uses ULocale, UFileAssoc;


procedure TFSetPassword.FormCreate(Sender: TObject);
begin
  SetDefaultSize(400, -1);
  Buttons := [mbOK, mbCancel];
  Caption := LANGFSetPassword_Caption;

  Table := TGTKTable.Create(Self);
  DialogIcon := TGTKImage.Create(Self);
  DialogIcon.CopyFromPixbuf(StockLock48);

  Label1 := TGTKLabel.Create(Self);
  Label1.Caption := Format('<span size="x-large" weight="bold">%s</span>', [LANGFSetPassword_Label1_Caption]);
  Label1.UseMarkup := True;
  Label1.XAlign := 0;
  Label2 := TGTKLabel.Create(Self);
  Label2.Caption := LANGFSetPassword_Label2_Caption;
  Label2.LineWrap := True;
  Label2.XAlign := 0;
  Label2.SetSizeRequest(270, -1);
  Entry := TGTKEntry.Create(Self);
  Entry.Visibility := False;
  ShowPasswordCheckButton := TGTKCheckButton.CreateWithLabel(Self, LANGFSetPassword_ShowPasswordCheckButton);
  ShowPasswordCheckButton.OnToggled := ShowPasswordCheckButtonClick;

  Table.AddControlEx(0, 0, 2, 1, Label1, [taoExpand, taoFill], [taoShrink], 20, 3);
  Table.AddControlEx(0, 1, 1, 1, DialogIcon, [taoShrink], [taoShrink], 10, 5);
  Table.AddControlEx(1, 1, 1, 1, Label2, [taoExpand, taoFill], [taoShrink], 5, 0);
  Table.AddControlEx(0, 2, 1, 1, TGTKVBox.Create(Self), [taoShrink], [taoShrink, taoExpand, taoFill], 2, 6);
  Table.AddControlEx(0, 3, 2, 1, Entry, [taoExpand, taoFill], [taoShrink], 5, 0);
  Table.AddControlEx(0, 4, 2, 1, ShowPasswordCheckButton, [taoExpand, taoFill], [taoShrink], 15, 5);
  Table.BorderWidth := 10;
  ClientArea.AddControlEx(Table, True, True, 0);
  OnKeyDown := FormKeyDown;
  Entry.SetFocus;
end;

procedure TFSetPassword.FormKeyDown(Sender: TObject; Key: Word; Shift: TShiftState; var Accept: boolean);
begin
  case Key of
    GDK_RETURN, GDK_KP_ENTER: ModalResult := mbOK;
    GDK_ESCAPE: ModalResult := mbCancel;
    GDK_M, GDK_Capital_M: if (Shift = [ssAlt]) then begin
                            ShowPasswordCheckButton.Checked := not ShowPasswordCheckButton.Checked;
                            Accept := False;
                          end;
  end;
end;

procedure TFSetPassword.ShowPasswordCheckButtonClick(Sender: TObject);
begin
  Entry.Visibility := ShowPasswordCheckButton.Checked;
end;




end.

