(*
    Virtual File System support
     - prototypes functions and types
    draft version 24

    used in Seksi commander and Tux Commander

    Copyright (C) 2003 Radek Cervinka <radek.cervinka@centrum.cz>
    Copyright (C) 2005-2008 Tomas Bzatek <tbzatek@users.sourceforge.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

unit uVFSprototypes;

interface

const
      cVFSVersion = 3;    //  current version of the VFS API

      //  Capabilities
      capVFS_nil = 0;
      capVFS_List = 1;
      capVFS_CopyOut = 2;
      capVFS_CopyIn = 4;
      capVFS_NeedsTemp = 8;   //  if not set, the seek operation is available  
      capVFS_Multiple = 16;   //  support multiple files - ?
      capVFS_Execute = 32;
      capVFS_Writable = 64;
      capVFS_NeedsLogin = 128;    //  Anonymous is login operation too


      //  Error codes (TVFSResult)
      cVFS_OK = 0;
      cVFS_Failed = 1;   // also No such file
      cVFS_Cancelled = 2;
      cVFS_Not_Supported = 3;
      cVFS_Not_More_Files = 4;   // returned while directory listing
      cVFS_ReadErr = 5;
      cVFS_WriteErr = 6;   //  also ReadOnlyFileSystem
      cVFS_LoginFailed = 7;
      cVFS_PermissionDenied = 8;
      cVFS_NoSpaceLeft = 9;
      cVFS_mallocFailed = 10;
      cVFS_BadPassword = 11;
      cVFS_MissingVolume = 12;
      cVFS_CorruptedArchive = 13;


      //  Open modes (for VFSOpenFile function) 
      cVFS_OpenRead = 0;
      cVFS_OpenWrite = 1;
      cVFS_OpenAppend = 2;



type
     TVFSResult = longint;
     TVFSGlobs = Pointer;
     //  The plugin can store some data into this object for identify the object instances
     //  It is allocated in the application side with the size returned by VFSAllocNeeded()
     //  Generally, it is required for correct cooperation of thread in the module

     //  File descriptor for Open, Read, Write, Close, Seek operations
     TVFSFileDes = Pointer;

     TVFSItemType = (vRegular=0, vSymlink=1, vChardev=2, vBlockdev=3, vDirectory=4, vFifo=5, vSock=6, vOther=7);

{$IFDEF KYLIX}
     DWORD = Cardinal;
//     ShortBool = boolean;
{$ENDIF}
{$IFNDEF CPU64}
     ShortBool = boolean;
{$ENDIF}



//  All filenames should be UTF-8 as much as possible


     PVFSItem = ^TVFSItem;
     TVFSItem = packed record
{$IFNDEF CPU64}   //  32-bit platform
       sFileName: PChar;
       iSize: Int64;
       m_time: DWORD;
       a_time: DWORD;
       c_time: DWORD;
       iMode: Integer;
       sLinkTo: PChar;
       iUID: Integer;
       iGID: Integer;
       ItemType: TVFSItemType;
{$ELSE}           //  64-bit platform
       sFileName: PChar;
       iSize: Int64;
       m_time: QWORD;
       a_time: QWORD;
       c_time: QWORD;
       iMode: Longint;
       __padding1: array[1..4] of byte;
       sLinkTo: PChar;
       iUID: Longint;
       iGID: Longint;
       ItemType: Longint;
       __padding: array[1..4] of byte;
{$ENDIF}
     end;

     //  This structure contains basic informations about the plugin (Name is used to identify the module in the application)
     TVFSInfo = packed record
       Name: PChar;
       Description: PChar;
       About: PChar;
       Copyright: PChar;
     end;

type
    //  Log function which could plugin call - the application must handle the messages (e.g. write them to the stdout)
    PVFSLogFunc = ^TVFSLogFunc;
    TVFSLogFunc = procedure(S: PChar); cdecl;

    TVFSAllocNeeded = function: integer; cdecl;
    //  Returns sizeof internal structure of TVFSGlobs in the plugin - host application will then allocate corresponding amount of memory
    TVFSInit = procedure (g:TVFSGlobs; LogFunc: PVFSLogFunc); cdecl;
    //  Performs intialization of the plugin and sets the log function for the module (assume allocated memory for TVFSGlobs)
    TVFSDestroy = procedure (g:TVFSGlobs); cdecl;
    //  Performs cleanup and destroy all objects
    TVFSVersion = function: integer; cdecl;
    //  Returns API Version; the host application checks for this number and if the returned number is less than a value required by the host application, the module is not loaded
    //  The current version for this API is '3' - please use the constant declared above as return value
    TVFSGetInfo = function: TVFSInfo; cdecl;
    //  Returns the structure with module info
    TVFSGetPrefix = function (g:TVFSGlobs): PChar; cdecl;
    //  Returns prefix used in the application to show difference between local and VFS filesystems (e.g. "ftp" or "smb")
    TVFSGetCharset = function (g:TVFSGlobs): PChar; cdecl;
    //  TODO: Returns charset which the plugin uses
    TVFSGetExts = function: PChar; cdecl;
    //  Returns the list of filename extensions which the module can handle separated by ';' (without a leading dots)
    TVFSGetServices = function: PChar; cdecl;
    //  Returns the list of supported remote protocols separated by ';' (without the '://')
    TVFSCaps = function (const sExt: PChar): Integer; cdecl;
    //  TODO: Returns a bit mask of plugin capabilities
    TVFSSetProtocolLogFunc = procedure (g:TVFSGlobs; ProtocolLogFunc: TVFSLogFunc); cdecl;
    //  TODO: Sets the protocol log function (unlike module debug log func this is intended only for server messages (FTP mainly))
    TVFSSetBlockSize = procedure (g:TVFSGlobs; Value: Cardinal); cdecl;
    //  Sets the block size for I/O operations (not all modules supports this)


    TVFSOpen = function (g:TVFSGlobs; const sName: PChar): TVFSResult; cdecl;
    //  TODO: Opens the location (file or URI/URL)
    TVFSLogin = function (g:TVFSGlobs; const User, Pass: PChar): TVFSResult; cdecl;
    //  TODO: Performs login to the server
    TVFSClose = function (g:TVFSGlobs): TVFSResult; cdecl;
    //  Closes the file or connection to the server
    TVFSMkDir = function (g:TVFSGlobs; const sDirName: PChar): TVFSResult; cdecl;
    TVFSRename = function (g:TVFSGlobs; const sSrcName, sDstName: PChar): TVFSResult; cdecl;
    //  Only rename/move in this function, the two files/directories have to be on the same filesystem - otherway it needs to be copied and deleted manually
    TVFSRemove = function (g:TVFSGlobs; const APath: PChar): TVFSResult; cdecl;
    //  Removes the file/directory (empty only!)
    TVFSFileExists = function (g:TVFSGlobs; const FileName: PChar; const Use_lstat: LongBool): LongBool; cdecl;
    //  This function checks for existing location; the Use_lstat parameter specifies to not follow the symlinks (default false = follow symlinks)
    TVFSMakeSymLink = function (g:TVFSGlobs; const NewFileName, PointTo: PChar): TVFSResult; cdecl;
    TVFSChmod = function (g:TVFSGlobs; const FileName: PChar; const Mode: integer): TVFSResult; cdecl;
    //  The parameter for this function is in classic unix format (glibc) - a bit mask
    TVFSChown = function (g:TVFSGlobs; const FileName: PChar; const UID, GID: integer): TVFSResult; cdecl;
    TVFSChangeTimes = function (g:TVFSGlobs; APath: PChar; mtime, atime: Longint): TVFSResult; cdecl;
    //  Changes times for the file/directory - mtime and atime are __time_t parameters (glibc)
    TVFSChangeDir = function (g:TVFSGlobs; const NewPath: PChar): TVFSResult; cdecl;
    //  Try to change the directory when correct permissions
    TVFSGetPath = function (g:TVFSGlobs): PChar; cdecl;
    //  Returns the current working path (not all plugins can support this; just return '/' in this case)
    TVFSGetFileSystemSize = function (g:TVFSGlobs; const APath: PChar): Int64; cdecl;
    //  Gets the size of filesystem; the path is optional, specified to recognize various mounted filesystems in the tree
    TVFSGetFileSystemFree = function (g:TVFSGlobs; const APath: PChar): Int64; cdecl;
    TVFSGetFSLabel = function (g:TVFSGlobs; const APath: PChar): PChar; cdecl;
    //  Gets the filesystem label
    TVFSIsOnSameFS = function (g:TVFSGlobs; const Path1, Path2: PChar): boolean; cdecl;
    TVFSTwoSameFiles = function (g:TVFSGlobs; const Path1, Path2: PChar): boolean; cdecl;
    //  Checks if the two files are simmilar (used to test the case-insensitive filesystem - or hardlinks)
    TVFSGetDirSize = function (g:TVFSGlobs; APath: PChar): Int64; cdecl;
    //  Calculates recursively the size of the tree specified under the path APath
    TVFSBreakGetDirSize = procedure (g:TVFSGlobs); cdecl;
    //  Call this function to break the calculation performed by VFSGetDirSize
    TVFSRun = function (g:TVFSGlobs; const sName: PChar): TVFSResult; cdecl;
    //  TODO: Runs the command read from inside the archive (typically installing the rpm package)

    
    TVFSCopyCallBackFunc = function (iPos, iMax: Int64; data: Pointer):LongBool; cdecl;
    //  Callback function used during the copy process; return False to break the copy process

    TVFSCopyOut = function (g:TVFSGlobs; const sSrcName, sDstName: PChar; pCallBackProgress: TVFSCopyCallBackFunc; data: Pointer; Append: LongBool): TVFSResult; cdecl;
    //  Performs the copy process from inside of module to the file in the local system
    //  (thus sSrcName is a path from inside of module and sDstName is path in the local filesystem where the file should be copied)
    //  The data pointer is then used to call the callback function in
    //  Note: if you need to transfer a file between two VFS modules, you need to do it manually - either first copy to local FS or use the Open, Read, Write functions of the module (NOTE: both VFS modules have to support these functions)

    TVFSCopyIn = function (g:TVFSGlobs; const sSrcName, sDstName: PChar; pCallBackProgress: TVFSCopyCallBackFunc; data: Pointer; Append: LongBool): TVFSResult; cdecl;
    //  Performs the copy process from the local filesystem into the module 


    //  This is the set of basic functions which can manipulate with the data
    //  There is a TVFSFileDes object which identifies the processed file (filedescriptor)
    //  All these functions needs a pointer to an int variable to store the error code
    //  NOTE: not all modules could support this set of functions due to its design (unable to set a solid block size)
    TVFSOpenFile = function (g:TVFSGlobs; const APath: PChar; Mode: integer; Error: Pinteger): TVFSFileDes; cdecl;
    //  Opens a file or creates new (the values for the Mode parameter are described above) and returns the assigned filedescriptor
    TVFSReadFile = function (g:TVFSGlobs; const FileDescriptor: TVFSFileDes; Buffer: Pointer; ABlockSize: integer; Error: Pinteger): integer; cdecl;
    //  Returns number of bytes read; the buffer needs to be allocated by a blocksize (set it by VFSSetBlockSize function)
    TVFSWriteFile = function (g:TVFSGlobs; const FileDescriptor: TVFSFileDes; Buffer: Pointer; BytesCount: integer; Error: Pinteger): integer; cdecl;
    //  Returns number of bytes written
    TVFSCloseFile = function (g:TVFSGlobs; const FileDescriptor: TVFSFileDes): TVFSResult; cdecl;
    TVFSFileSeek = function (g:TVFSGlobs; const FileDescriptor: TVFSFileDes; const AbsoluteOffset: Int64; Error: Pinteger): Int64; cdecl;
    //  Sets the position in the file from the start and returns real current position


    //  These are the functions used to list the contents of the directory
    //  First call the VFSListFirst function and then repeat call of VFSListNext until it returns NULL.
    //  Then call VFSListClose to make cleanup
    TVFSListFirst = function (g:TVFSGlobs; const sDir: PChar; VFSItem: PVFSItem): TVFSResult; cdecl;
    TVFSListNext = function (g:TVFSGlobs; const sDir: PChar; VFSItem: PVFSItem): TVFSResult; cdecl;
    TVFSListClose = function (g:TVFSGlobs): TVFSResult; cdecl;
    TVFSFileInfo = function (g:TVFSGlobs; AFileName: PChar; VFSItem: PVFSItem): TVFSResult; cdecl;
    //  Gets a single info item without need to list a whole directory

    TVFSSetPassword = function (g:TVFSGlobs; pass: PChar): TVFSResult; cdecl;
    TVFSGetPasswordRequired = function (g:TVFSGlobs): LongBool; cdecl;

    /// pridat neco jako set_loglevel ??

//// pridat typ pluginu - jestli archive nebo protocol - prip. jeste pridat ktery protokoly je to schopno handlovat

    
//  TODO: some function to check the CRC of the archive - it should need also some progress feedback - the processed file and percentage progress

implementation

end.
