<?php	// TWIG		Standard Group related functions.	?>
<?php

if( !$included["lib/groups/standard.groups.inc.php3"] )
	{
	$TWIGCurrentGroupFeatures = array( 	array( "name"=>"todo", "table"=>$dbconfig["todo_table"] ),
						array( "name"=>"contacts", "table"=>$dbconfig["contact_table"] ),
						array( "name"=>"schedule", "table"=>$dbconfig["schedule_table"] ),
						array( "name"=>"bookmarks", "table"=>$dbconfig["bookmarks_table"] ),
						array( "name"=>"notes", "table"=>$dbconfig["notes_table"] )
					 );
	//Initialize the group cache
	$TWIGGroupsCache = array( "0" => array( "name" => TWIGPhrase( "Unfiled" ), "member" => TRUE, "type" => "standard", "owner"=>"*"),
				  "*" => array(	"name" => TWIGPhrase( "ALL" ), "member" => TRUE, "type" => "standard", "owner"=>"*")
				);

	Function TWIGGroupsCreateSQLGroupQuery($username, $grouplist, $table="", $perms=0)
		{
		TWIGDebug("TWIGGroupsCreateSQLGroupQuery( \"$username\", array, \"$table\", $perms );");

 		if( !is_array( $grouplist ) ) { $grouplist = array( "*" ); }
		if ($table) { $table .= "."; }

		for ($i=0, $j=count($grouplist); $i<$j; ++$i)
			{
			if ($ret) {$ret .= " OR ";}
			if($grouplist[$i]=="*")
				{
			  	$ret = "(" . $table . "username = '$username' AND " . $table . "groupid=0)";
				$gm = TWIGGroupsMembership($username);
				if($gm) { $ret .= " OR " . $table . "groupid=" . join($gm, " OR " . $table . "groupid = ");}
				$i=$j;
				}
			elseif($grouplist[$i]=='0') {$ret .= "(" . $table . "username='$username' AND " . $table . "groupid=0)";}
			elseif(TWIGGroupsMemberOf($grouplist[$i])) {$ret .= $table . "groupid=" . $grouplist[$i];}
			}
		return $ret;
		}

	Function TWIGGroupsGetName($gid) 
		{
  		Global $dbconfig, $TWIGGroupsCache;
		TWIGDebug( "TWIGGroupsGetName( \"$gid\" );", 20 );
	  	if(!isset($TWIGGroupsCache[$gid]["name"] ))
			{
	   		$result = dbQuery("SELECT groupname FROM " . $dbconfig["groups_table"] . " WHERE id = '$gid'" );
			if(dbNumRows($result)) {$TWIGGroupsCache[$gid]["name"] = dbResult($result, 0, "groupname");}
			else {$TWIGGroupsCache[$gid]["name"] = TWIGPhrase( "[empty]" );}
			}
		return $TWIGGroupsCache[$gid]["name"];
   		}

 	Function TWIGGroupsMemberOf($gid, $perms=0) 
		{
	  	Global $login, $dbconfig, $TWIGGroupsCache, $disabled;
		TWIGDebug( "TWIGGroupsMemberOf( \"$gid\", \"$perms\" );", 20 );

		if(!$TWIGGroupsCache[$gid]["member"])
			{
			if($disabled["global_groups"]) { $result=dbQuery("SELECT username FROM " . $dbconfig["members_table"] . " WHERE username='" . $login["username"] . "'  AND groupid='$gid'"); }
			else { $result=dbQuery("SELECT username FROM " . $dbconfig["members_table"] . " WHERE (username='" . $login["username"] . "' OR username='*') AND groupid='$gid'"); }
			if(dbNumRows($result))
				{
				$TWIGGroupsCache[$gid]["member"]=TRUE;
				}
			}
		return ($TWIGGroupsCache[$gid]["member"] || (TWIGGroupsOwner($gid) == $login["username"]));
		}

	 // Returns members and owner of $gid group
	 Function TWIGGroupsMembers($gid, $perms=0) 
		{
	  	Global $dbconfig;
	
		TWIGDebug( "TWIGGroupsMembers( \"$gid\", \"$perms\" );", 20 );

	  	if( $gid == "*" ) {$query = "SELECT username FROM " . $dbconfig["members_table"];}
	  	else {$query = "SELECT username FROM " . $dbconfig["members_table"] . " WHERE groupid = '$gid'";}
		$result = dbQuery( $query );
	  	for($i=0, $j=dbNumRows($result); $i<$j; ++$i) { $members[] = dbResult($result, $i, "username"); }
		// Insert owner into list
		$members[]=TWIGGroupsOwner($gid);
  		return $members;
	 	}
	
	 // Returns Groups $user is a member or owner of
	 Function TWIGGroupsMembership($user, $perms=0) 
		{
	  	Global $dbconfig, $TWIGGroupsCache, $disabled;

		TWIGDebug( "TWIGGroupsMembership( \"$user\" );", 20 );
		if($disabled["global_groups"]) { $result = dbQuery("SELECT groupid,username FROM " . $dbconfig["members_table"] . " WHERE username = '$user'"); }
		else { $result = dbQuery("SELECT groupid,username FROM " . $dbconfig["members_table"] . " WHERE username = '$user' OR username='*'"); }
		$j = dbNumRows($result);

		// First grab the groups $user owns
		$groups=TWIGGroupsOwnership( $user );

	  	for($i = 0; $i < $j; ++$i) 
			{
			$groupdata = dbResultArray($result, $i);
			$gid = $groupdata["groupid"];
			if(!isset($TWIGGroupsCache[$gid]["type"]))
				{
				$result2 = dbQuery( "SELECT type FROM " .  $dbconfig["groups_table"] . " WHERE id='$gid'");
				if(dbNumRows($result2)) {$TWIGGroupsCache[$gid]["type"] = dbResult($result2, 0, "type");}
				}
			if($TWIGGroupsCache[$gid]["type"] == "standard")
				{
				$TWIGGroupsCache[$gid]["member"]=TRUE;
				$groups[] = $gid;
				}
	  		}

		//Kill duplicates caused by global groups
		if($groups)
			{
			sort($groups);
			$groupsfinal[]=$groups[0];
			for($i=1, $j=count($groups); $i<$j; ++$i)
				{
				if($groups[$i] != $groups[$i-1]) {$groupsfinal[] = $groups[$i];}
				}
			return $groupsfinal;
			}
		else {return array();}
	 	}
	
	 // Returns owner of $gid group
	 Function TWIGGroupsOwner($gid)
		{
		Global $dbconfig, $TWIGGroupsCache;

		TWIGDebug("TWIGGroupsOwner( \"$gid\" );", 20);

		if(!$TWIGGroupsCache[$gid]["owner"])
			{
			$result=dbQuery("SELECT owner FROM " . $dbconfig["groups_table"] . " WHERE id='$gid'");
			$TWIGGroupsCache[$gid]["owner"]=dbResult($result, 0, "owner");
			}
		return $TWIGGroupsCache[$gid]["owner"];
		}

	 // Returns groups $user is owner of
	 Function TWIGGroupsOwnership($user)
		{
		Global $dbconfig, $TWIGGroupsCache;

		TWIGDebug("TWIGGroupsOwnership( \"$user\" );", 20);

		$groups = array();

		$result=dbQuery("SELECT id,type FROM " . $dbconfig["groups_table"] . " WHERE owner='$user'");
		for ($i=0, $j=dbNumRows($result); $i<$j; ++$i)
			{
			$groupdata=dbResultArray($result, $i);
			$TWIGGroupsCache[$groupdata["id"]]["type"] = $groupdata["type"];
			$TWIGGroupsCache[$groupdata["id"]]["owner"]=$user;
			if($groupdata["type"]=="standard") {$groups[]=$groupdata["id"];}
			}
		return $groups;
		}
	
	Function TWIGGroupSortArray($first, $second)
		{
		return strcasecmp($first["description"], $second["description"]);
		}

	Function TWIGGroupsSelect($username = "", $gid = "" , $is_listoption = "", $perms=0)
		{
		Global $session, $login, $TWIGGroupsCache;
	
		TWIGDebug("TWIGGroupsSelect( \"$username\", \"$gid\", \"$is_listoption\" );");

		if(!$username) {$username=$login["username"];}
	
	  	$groups=TWIGGroupsMembership($username);
		$garray[]=array("description"=>$TWIGGroupsCache["*"]["name"], "id"=>"*");
		$garray[]=array("description"=>$TWIGGroupsCache["0"]["name"], "id"=>"0");
	
		for($x=0, $y=count($groups); $x<$y; ++$x) 
			{
			$garray[] = array("description"=>TWIGGroupsGetName($groups[$x]), "id"=>$groups[$x]);
			}

		usort($garray, TWIGGroupSortArray);

		for($x=0, $y=count($garray); $x<$y; ++$x) 
			{
			if($garray[$x]["id"]==$gid) {$selected=" selected";} else { $selected = ""; }

	                if(!($is_listoption=="" && $garray[$x]["id"]=="*"))
				{ 
				$str .= "<option value=\"" . $garray[$x]["id"] . "\"" . $selected . ">" . $garray[$x]["description"] . "</option>\n";
			 	}
			}
	  
		return $str;
	 	}
	
	Function TWIGGroupsSelector($Username = "", $GID = "", $IsListOption = "", $OptionName = "data_thisGroup", $GoName = "TWIGChangeGroup", $perms=0)
		{
		Global $config, $context;

		TWIGDebug( "TWIGGroupsSelector( \"$Username\", \"$GID\", \"$IsListOption\", \"$OptionName\", \"$GoName\" );" );

		$ret  = "<form action=\"" . $config["baseurl"] . "\" method=\"post\">\n";
   		$ret .= TWIGSession("put");
	   	$ret .= TWIGContext("put", $context["feature"]);
   		$ret .= TWIGPhrase( "Group" ) . ":&nbsp;"; 
   		$ret .= "<select name=\"" . $OptionName . "\" onChange=\"this.form.submit()\">\n";
   		$ret .= TWIGGroupsSelect($Username, $GID , $IsListOption);
	   	$ret .= "</select>\n";
   		$ret .= "<input type=\"submit\" value=\"" . TWIGPhrase( "Go" ) . "\" name=\"" . $GoName . "\">\n";
  		$ret .= "</form>\n";

		return $ret;
		}

	// Set group query info according to membership, etc.
	// if no group, set to default
	$featureGroup = $context["feature"] . "Group";
	$defaultgroup = GetPref("viewgrp", $dbconfig[$context["feature"] . "_prefs_table"], $config["defaults"][$context["feature"]]["viewgrp"]);
	if( !$defaultgroup ) { $defaultgroup = "*"; }

	if( isset( $data_thisGroup ) ) { $group = $data_thisGroup; }
	elseif( isset( $session[$featureGroup] ) ) { $group = $session[$featureGroup]; }
	else { $group = $defaultgroup; }

	if( TWIGGroupsMemberOf( $group ) ) { TWIGSessionSet( $featureGroup, $group, $defaultgroup ); } else { TWIGSessionSet( $featureGroup, "*", $defaultgroup ); }

	//$groupquery is depreciated:  Use TWIGGroupsCreateSQLGroupQuery() instead.
	$groupquery=TWIGGroupsCreateSQLGroupQuery($login["username"], array($session[$featureGroup]));
	if (!$groupquery) {$groupquery = "username='" . $login["username"] . "'";}

	$included["lib/groups/standard.groups.inc.php3"] = 1;
	}	
?>
