<?php
if (!defined ('TYPO3_MODE')) 	die ('Access denied.');

/**
 * Setting up TYPO3 to work with Photo Marathon table in the database
 * The configuration is 'dynamic' which means that only the [ctrl] section of the $TCA array for user_photomarathon, is configured here. 
 * All the other parts - that is the fields of the table - is configured in the file, tbl_user_photomarathon.php.
 * That script is refered to by the 'ctrl' option 'dynamicConfigFile'
 */
$TCA['user_photomarathon'] = Array (
	'ctrl' => Array (
		'label' => 'title',				// Fieldname to show as a title in the List submodule of the TYPO3 interface
		'tstamp' => 'tstamp',			// Fieldname to be updated with a timestamp every time the record is edited
		'crdate' => 'crdate',			// Fieldname to be updated with the date of creation
		'fe_cruser_id' => 'fe_cruser_id',	// Fieldname to be set to the fe_users.uid of the front end user who creates the record - and who has access to it afterwards.
		'delete' => 'deleted',			// Fieldname to be set to 1 upon deletion. BEWARE: When TYPO3 deletes the record, it's not really deleted - only 'hidden' by the fact that this flag is true. However ANY selecting query of TYPO3 is required to exclude records with the delete flag set!
		'title' => 'LLL:EXT:user_photomarathon/locallang_tables.php:table_title',	// Table title
		'iconfile' => t3lib_extMgm::extRelPath($_EXTKEY).'photomarathon/user_pm_icon.gif',
		'enablecolumns' => Array (
			'disabled' => 'hidden',		// Fieldname to be used as disabled column. Value of the field: 0=enabled (shown), 1=disabled (hidden, which also results in a dimmed icon!)
		),
		'dynamicConfigFile' => t3lib_extMgm::extPath($_EXTKEY).'res/tbl_user_photomarathon.php'
	),
		// The list of fields which are ALLOWed exclusively for editing by the fe_adminLib in the front end!!
	'feInterface' => Array (
		'fe_admin_fieldList' => 'title,description,images,hidden,photodate',
	)
);


/**
 * The next step is to define on which page doktypes the record is allowed to be located. 
 * The 'sysFolder' doktype of a page is able to contain all kinds of records. 
 * But we would like to have user_photomarathon image records on regular pages! 
 * So we must add this to the PAGES_TYPES table. 
 * This is standard procedure done by this function:
 */
t3lib_extMgm::allowTableOnStandardPages('user_photomarathon');


/**
 * Setting up a user defined submodule in the Web module of the backend
 *
 * See typo3conf/web/uphotomarathon/ for the PHP code of the module. This modification below just adds the submodule to the web-module
 *
 * Module name is prepended with a 'u' because it's a user defined module. 
 * You can be sure that public modules will not be prepended 'u'.
 */

if (TYPO3_MODE=='BE')	{
	t3lib_extMgm::addModule('web','uphotomarathon','',t3lib_extMgm::extPath($_EXTKEY).'modsub/');
}


/**
 * Registering a locallang file for table descriptions for the "user_photomarathon" table:
 */
t3lib_extMgm::addLLrefForTCAdescr('user_photomarathon','EXT:user_photomarathon/locallang_csh_tables.php');

?>