#ifndef SIGNAL_HH
#define SIGNAL_HH

/** Copyright (c) 1995 Ohio Board of Regents and the University of
    Cincinnati.  All Rights Reserved.

    You may modify, distribute, and use the software contained in this
    package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
    version 2, June 1991. A copy of this license agreement can be found
    in the file "LGPL", distributed with this archive.

    $Id: Signal.hh,v 1.1 2003/12/04 19:13:18 dmartin Exp $ */

#include "tyvis/SignalBase.hh"

class SourceBase;
class VHDLProcess;

template <class Type> 
class Signal : public SignalBase {
public:
  Signal();
  Signal(const VHDLData&);
  Signal(const Signal&);
  Signal(const int);
  ~Signal();

  bool _is_resolved() const {
    return (source->getResolutionFnId() != SourceBase::DEFAULT_RF_ID);
  }

  virtual ObjectType getKind() const {return SIGNAL;}
  ObjectBase& operator=(const ObjectBase&);
  ObjectBase& operator=(const VHDLData&);
  Signal<Type>& operator=(const Signal<Type>& rhs) {
    this->operator=((const ObjectBase &) rhs);
    return *this;
  }
  
  void print(ostream&) const;

  void updateDriver( const int, 
			    int processId,
			    const VHDLData *, 
			    const ArrayInfo *, 
			    const ArrayInfo * = NULL );

  void disconnectDriver(VHDLKernel *);

  VHDLType *readDriver(VHDLKernel *);
  void updateDrvVal(const VHDLData*, const ArrayInfo* = NULL, 
		    const ArrayInfo* = NULL);
  VHDLData *readDrvVal();
  virtual void updateEffVal(const VHDLData&, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  virtual void updateEffVal(const VHDLData*, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  VHDLData *readEffVal();
  vector<FanDest *> &getFanList() const;

  /** Number of sources will be fixed in initState() after dynamic
      elaboration.  Sources for this signal. if numSources > 1, busResFn
      must be valid */
  SourceBase* source;
  
  /** driving value of the signal. */
  Type drvVal;
  
  /**  effective value of the signal */
  Type effVal;       

  /** a flag to find out whether to delete the source tree or not.
      Before type conversion was implemented, the source tree was
      deleted by the SignalNetinfo. But now, they are loosing the tree,
      so this way. */
  bool sourceBaseDeleteFlag;

  const VHDLData& readVal() const {
    return ((VHDLData&) effVal);
  }

  virtual void updateVal( const VHDLData& val ){
    updateEffVal( &val );
  }

  void setSource(SourceBase *src) {
    source = src;
  }

  ObjectBase* clone() const {
    Signal<Type> *retval = new Signal<Type>;
    *retval = *this;
    return retval;
  }

  VHDLType *resolve( VHDLKernel * );
  bool compositeResolvedSignal;

  void setCompositeResolvedSignal(bool val) {
    compositeResolvedSignal = val;
  }

  bool isCompositeResolvedSignal() const {
    return compositeResolvedSignal;
  }

  virtual SignalBase *findSigInBlock( int sigId, VHDLKernel *srcId );

  virtual void set_sourcebase_delete_flag(bool flag) {
    sourceBaseDeleteFlag = flag;
  }
  
  SourceBase* getSource() {
    return source;
  }
};

template <class Type>
ostream& operator << (ostream& os, Signal<Type> sig) {
  os << *sig.readEffVal();
  return os;
}

#include "tyvis/Signal.cc"
#endif
