#ifndef WAIT_HH
#define WAIT_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Wait.hh,v 1.2 2003/12/08 19:24:39 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "tyvis/vhdl.hh"
#include "tyvis/std_standardPkg.hh"
#include "tyvis/RecordType.hh"
#include "tyvis/ArrayType.hh"
#include <vector>
using std::vector;

extern bool defaultWaitCond( VHDLKernel * );
extern PhysicalType defaultWaitTimeout( VHDLKernel * );

typedef bool (*waitConditionPtr)( VHDLKernel * );
typedef PhysicalType (*waitTimeoutPtr)( VHDLKernel * );

class Wait {
public:  
  unsigned int getSensSize() const { return sensList.size(); }

  Wait() :
    cond( defaultWaitCond ),
    timeout( defaultWaitTimeout ){}

  void destructSensitivityList();
  void addSensitivityTo( VHDLType * );

  Wait& operator=(const Wait &);
  
  bool sensitiveTo(int sigid);
  void print(ostream& = cout) const;
private:
  vector<VHDLType*> sensList;
  waitConditionPtr cond;
  waitTimeoutPtr timeout;


  bool isSensitive(int sigid, ScalarType* signal);
  bool isSensitive(int sigid, VHDLType* signal);
  bool isSensitive(int sigid, RecordType* signal);
  bool isSensitive(int sigid, ArrayType* signal);
};
#endif
