//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uFilebuf.h -- nonblocking stream buffer
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:45:30 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 17 17:04:04 2004
// Update Count     : 24
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_FILEBUF_H__
#define __U_FILEBUF_H__

#include <uFile.h>

#pragma __U_NOT_USER_CODE__

#include <fstream>

#define __U_BUFFER_SIZE__ 512

class uFilebuf : public std::filebuf {
    uFile *ufile;
    uFileAccess *ufileacc;
    char buffer[__U_BUFFER_SIZE__];
    int endOfFile;

    int IosToUnixMode( std::ios_base::openmode mode );
    int CharToUnixMode( const char *mode );
  public:
    uFilebuf( std::ios_base::openmode mode );
    uFilebuf( int fd, std::ios_base::openmode mode, int bufsize = __U_BUFFER_SIZE__ );
    uFilebuf( int fd, std::ios_base::openmode mode, char *buf, int bufsize );
    virtual ~uFilebuf();

    bool is_open() const;
    uFilebuf *open( const char *filename, std::ios_base::openmode mode );
    uFilebuf *close();

    int fd();
  protected:
    std::streambuf::int_type overflow( std::streambuf::int_type c = EOF );
    std::streambuf::int_type underflow();
    std::streambuf::int_type uflow();
    std::streamsize xsputn(const char* __s, std::streamsize __n);
    std::streambuf::pos_type seekoff( std::streambuf::off_type off, std::ios_base::seekdir dir, std::ios_base::openmode which = std::ios_base::in | std::ios_base::out );
    std::streambuf::pos_type seekpos( std::streambuf::pos_type sp, std::ios_base::openmode which = std::ios_base::in | std::ios_base::out );
    int sync();
}; // uFilebuf


#pragma __U_USER_CODE__

#endif // __U_FILEBUF_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
