//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Ashif S. Harji 2000
// 
// uPIHeap.cc -- 
// 
// Author           : Ashif S. Harji
// Created On       : Fri Feb  4 11:10:44 2000
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 10 10:29:31 2005
// Update Count     : 43
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uStaticPIQ.h>
//#include <uDebug.h>

#include <cstring>					// access: ffs


uStaticPIQ::uStaticPIQ() {
    for ( int i = 0; i < __U_MAX_NUMBER_PRIORITIES__ ; i += 1 ) {
	uObjects[i] = 0;
    } // for
    uMask = 0;

} // uStaticPIQ::uStaticPIQ

bool uStaticPIQ::empty() const {
    return uMask == 0;
} // uStaticPIQ::empty

//int uStaticPIQ::head() {			
//	int highestPriority = ffs( uMask ) - 1;
//
//	if ( highestPriority >= 0 ) {
//	    return highestPriority;
//	} else {
//	    return -1;
//	} // if
//
//} // uStaticPIQ::head

int uStaticPIQ::uGetHighestPriority() {			
	int highestPriority = ffs( uMask ) - 1;

	if ( highestPriority >= 0 ) {
	    return highestPriority;
	} else {
	    return -1;
	} // if
} // uStaticPIQ::uGetHighestPriority

void uStaticPIQ::add( int priority ) {	
    lock.acquire();

    uAssert( 0 <= priority && priority <= __U_MAX_NUMBER_PRIORITIES__ - 1 );
    uObjects[priority] += 1;
    uMask |= 1ul << priority;

    lock.release();
} // uPriorityScheduleQueue::add

int uStaticPIQ::drop() {				
    lock.acquire();
    
    int highestPriority = ffs( uMask ) - 1;
	
    if ( highestPriority >= 0 ) {
	uObjects[highestPriority] -= 1;

	if ( uObjects[highestPriority] == 0 ) {
	    uMask &= ~ ( 1ul << highestPriority );
	} // if
	
    } // if

    lock.release();
    return highestPriority;
} // uStaticPIQ::drop

void uStaticPIQ::remove( int priority ) {		
    lock.acquire();

    uAssert( 0 <= priority && priority <= __U_MAX_NUMBER_PRIORITIES__ - 1 );
    uObjects[priority] -= 1;
    if ( uObjects[priority] == 0 ) {
	uMask &= ~ ( 1ul << priority );
    } // if

    lock.release();
} // uStaticPIQ::remove


// Local Variables: //
// compile-command: "gmake install" //
// End: //
