/* ==================================================== ======== ======= *
 *
 *  uviewImpl.hpp [internal implementation: do not use]
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:02] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uviewImpl.hpp	ubit:03.06.03"
#ifndef _uviewImpl_hh
#define	_uviewImpl_hh
#include <ubit/uevent.hpp>
#include <ubit/uborder.hpp>

// ====[internal implementation]===========================

struct UMultiList {
public:
  static const int MAXCOUNT = 2;
private:
  ULink *list_tab[MAXCOUNT];
  int count;
  bool is_softwin_list;
public:
  // parses the child list of grp, finds the 1st visible element (UElem or UGroup)
  // and adds it (and its followers) as a sublist
  // also checks HARDWIN and SOFTWIN_LIST
  UMultiList(class UContext& curp, UGroup* grp, bool rescale);

  bool isSoftwinList() {return is_softwin_list;}

  // adds an Elem (and its followers) as a sublist of the MultiList
  void addList(ULink *l);
  void addSoftwinList(UGroup *grp);

  // !! doit imperativement etre appele en premier!!
  ULink* first() {return list_tab[count = 0];}

  ULink* next(ULink *ch) {
    if (ch->getNext()) return ch->getNext();
    else if (++count < MAXCOUNT) return list_tab[count];
    else return null;
  }
};

// ==================================================== [Elc:02] ======= //
// ==================================================== ======== ======= //
// View extensions: used by certain views when useful

struct UViewExt {
  // used by viewMove and viewResize callbacks
  // for checking if pos or size has changed
  URegion* old_region;

  u_dim kept_width, kept_height;

  UViewExt();
  ~UViewExt();
};

// ==================================================== [Elc:02] ======= //
// ==================================================== ======== ======= //

struct UViewLayout {
  enum {NORMAL=0, GET_HINTS, IMPOSE_WIDTH, NESTED} strategy;
  u_dim spec_w, spec_h, cmin_w, cmax_w, cmin_h, cmax_h, line_h, line_w;
  UViewLayout() : strategy(NORMAL) {}
};

/* ==================================================== ======== ======= */

struct UViewLayoutImpl {
  UView *view;
  int visibleElemCount;  // UBox or UElem (not UGroup, not floating)
  int children_w, children_h;
  unsigned char orient;
  bool mustLayoutAgain;

  UViewLayoutImpl(UView*);
  void computeWidth(const UContext& curp, const UMargins&,
		    class UViewLayout&, bool minmax_defined = false);
  void computeHeight(const UContext& curp, const UMargins&,
		     class UViewLayout&, bool minmax_defined = false);
};

// ==================================================== [Elc:02] ======= //
// ==================================================== ======== ======= //

struct UViewUpdate {
  // !BEWARE: order is MEANINGFUL: all ITEM operations must be > ITEM_OPS
  enum Mode {
    PAINT_ALL,       // Paint all objects in clipping area
    PAINT_DAMAGED,   // Just paint damaged objects and their children,
    //MAIS AUSSI toutes les vues soeurs qui suivent (a cause des vues 
    //evntuellement superposees, voir note dans UViewUpdateData ci-dessous)
    //PAINT_CHANGED, // Just paint objects whose size or pos has changed
    UPDATE_DATA,     // Just update data, do not paint
    LOCATE_ELEM_POS, // Locate an UElem from its pos - do NOT paint it
    LOCATE_ELEM_PTR  // Locate an UElem from a link or a pointer
  } mode;
  UEvent *e;
  class UElemProps* elem_props;  // optional, used when searching UElems

  // when applicable (mode PAINT_DAMAGED) : 0 before drawing any damaged,
  // > 0 No (depth) of the damaged view, < 0 after painting the first damaged
  int damaged_level;
  // true when one or several damaged views have been processed
  bool after_damaged;
  // number of views to repaint above damaged objects
  int above_damaged_count;

  UViewUpdate(Mode _mode) {
    mode = _mode;
    e = null; 
    elem_props = null;
    // overlapp = 0;
    damaged_level = 0;
    after_damaged = false;
    above_damaged_count = 0;
  }

  void setMode(Mode _mode) {mode = _mode;}
  Mode getMode() {return mode;}
};

/* ==================================================== ======== ======= */

struct UViewUpdateImpl : public URegion {
  UView*  view;
  UMargins margins;        // a enlever a terme?
  URegion chr, chclip;
  u_dim   vflex_space, hflex_space;
  bool    can_paint;
  unsigned char orient;
  UViewUpdate& upmode;
  class UTableView* tabview;
  class UEdit* edit;

  UViewUpdateImpl(UView*, const URegion& r, UViewUpdate&);
  virtual ~UViewUpdateImpl();

  virtual void updateBackground(class UWinGraph&, UContext &curp, 
				const URegion &r, const URegion& clip);
  virtual void setMargins(class UWinGraph&, const UContext &curp, 
			  const URegion &r, bool add_frame_and_paddind);
  virtual void setFloating(UContext& curp, UGroup* grp, URegion& r);
  virtual void callbacks(UGroup*, UView* winview);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:02] ======= */

