/* ==================================================== ======== ======= *
 *
 *  umssource.hpp : UMS event sources.
 *
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)umssource.hpp	ubit:03.05.05"
#ifndef _umssource_hpp_
#define	_umssource_hpp_
#include <vector>

/* ==================================================== ======== ======= */
/**
 * UMS event source.
 */
class UMSeventSource {
public:
  UMSeventSource() {fd = -1;}
  virtual ~UMSeventSource() {fd = -1;}

  int  filedesc() const {return fd;}
  bool is_open()  const {return fd != -1;}

  virtual bool read() = 0;
  ///< reads and process incoming data.

  virtual bool canCalibrate() const {return false;}
  virtual void calibrate() {}
  ///< calibrates the device (if this device can be calibrated).

  class UMSbuttonMapping* getButtonMapping(u_int source_button,
					   u_int source_modifiers);

  void setButtonMapping(class UMSbuttonMapping*);
  void setButtonMapping(u_int source_button, 
			u_int source_modifiers,
			u_int flow_button,
			u_int flow_modifiers);
  /**< 
   * changes the events generated by the buttons of the native mouses
   * rule:
   * (source_button, source_modifiers ==> flow_button, flow_modifiers)
   *
   * useful for machines that do not have 3 buttons such as the IPAQ
   * button mapping can also be done for the native mouses
   * (see UMServer::setNativeButtonMapping)
   */

protected:
  int fd;
  std::vector<class UMSbuttonMapping*> button_map;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
