#include <iostream>
#include <stdio.h>
#include "uremote.hpp"
#include <ubit/unatdisp.hpp>
#include <X11/cursorfont.h>
#include <X11/Xmu/WinUtil.h>
using namespace std;

const int ARROW_SCALE = 14;

// NB: les hosts sont init. par fichier .uhosts s'il exsite
// sinon pris dans cette liste (si non vide)
const char* Remote::default_hosts[] = {  
  null
};

const char* Remote::default_files[] = {
  "~/demo/",
  "~/demo/intro/slide  1.html",
  "~/demo/claudie/slide  1.html",
  "~/demo/stuart/slide  1.html",
  "~/demo/regroup/slide  1.html",
  "~/demo/naviguide/slide  1.html",
  "~/demo/claudie/slide  8.html",
  "~/demo/",
  "~/demo/intro/",
  "~/demo/claudie/",
  "~/demo/stuart/",
  "~/demo/regroup/",
  "~/demo/naviguide/",
  null
};

const char* Remote::default_urls[] = {
  "http://www.infres.enst.fr/~elc/",
  "http://www.infres.enst.fr/~elc/ubit/",
  "http://www.infres.enst.fr/~dax/",
  "http://www.infres.enst.fr/~dax/vreng",
  "http://www.infres.enst.fr/~elc/campmob/",
  "http://www.infres.enst.fr/~elc/campmob/demo/intro/slide  1.html",
  "http://www.infres.enst.fr/~elc/campmob/demo/claudie/claudie.html",
  "http://www.infres.enst.fr/~elc/campmob/demo/regroup/",
  null
};

const char* Remote::default_scenes[] = {
  "Rendezvous",
  "test",
  "mythology",
  "movies",
  "android",
  "campus",
  "ubit",
  null
};

const char* CampusPanel::targets[] = {
  "campus",
  "ubrowser",
  null
};

const char* VrengPanel::targets[] = {
  "vreng",
  "vreng-ogl",
  null
};

const char* NetscapePanel::targets[] = {
  "Mozilla",
  "Netscape",
  null
};

// DEPEND DE LA PLATEFORME !!!
NetscapePanel::Profile NetscapePanel::prof  = {
  {130, 44}, {176, 43},		  // reload, stop, 
  {40, 44}, {160, 78}, {86, 44},  // back, home, forward,
  {24, 116}, {84, 116}, {48, 116} // previous, top, next;
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

int main(int argc, char* argv[]) {

  UConf conf(argc, argv);
  conf.double_buffering = false;
  conf.transp_scrollbars = false;

  UAppli appli(conf);

  const char* hname = null;
  if (argc == 2)  hname = argv[1];
  else hname = "localhost";

  Remote remote(hname);

  UFrame frame(utitle("UMS Remote Control")
               + uwidth(240) + uheight(320)
               + remote);
  appli.add(frame);
  frame.show();
  return appli.mainLoop();
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// UTILITAIRES a mettre dans lib a terme

void copyBoxText(UEvent& e, UStr* target) {
  if (target && e.getSource()) {
    e.getSource()->copyText(*target);
  }
}

void showCard(UPane* cardbox, UBox* _card) {
  UListPos lpos;
  UBrick* child = null;

  while ((child = cardbox->getChild(lpos))) {
    UBox* card = dynamic_cast<UBox*>(child);
    if (card) {
      if (card == _card) card->show(true);
      else card->show(false);
    }
  }
}

void showCard(UPane* cardbox, int index) {
  UListPos lpos;
  int ix = 0;
  UBrick* child = null;

  while ((child = cardbox->getChild(lpos))) {
    UBox* card = dynamic_cast<UBox*>(child);
    if (card) {
      if (ix == index) card->show(true);
      else card->show(false);
      ix++;
    }
  }
}

void showCard(UEvent& e, UPane* cardbox) {
  // getSource() returns the listbox
  // getTarget() returns the selected item
  // (we dont need the item here but the item index)
  UListbox* list = e.getSource() ? dynamic_cast<UListbox*>(e.getSource()) : null;
  if (list) showCard(cardbox, list->choice().getIndex());
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

Remote::Remote(const UStr& _hostname, const UArgs& args) :
UBox(args),
client(null)
{
  // always 1 item in the list
  UListbox& hlist = ulistbox(uitem(ustr(_hostname)));
  hlist.add(ucall(this, &hlist, &Remote::setHost));

  // lire host dans fichiers .uhosts (sinon liste en dur)
  if (UStr::readFile("~/.uhosts", hosts, true, true) > 0)
    cout << "hostfile: ~/.uhosts" << endl;

  if (hosts.size() > 0) hlist.addItems(hosts);
  else hlist.addItems(default_hosts);

  host_panel.addlist
    (
     UBgcolor::lightgrey
     + uhmargin(7) + uvmargin(7)+ uvspacing(8)
     + ulabel(uhcenter() + UFont::bold + "Select Host")
     + uvflex()
     + host_spane.addlist(hlist)
     + ubottom()
     //+ uhbox(uhflex() +utextbox("") 
     //	     + uright() + ubutton("Add" + ucall(this, &hlist, &Remote::addHost))
     //	     )
     + uhbox(uhcenter() + UFont::large + UFont::bold
	     + ubutton(UPix::ray + "Connect" 
		       + ucall(this, &hlist, &Remote::setHost))
	     )
     + uvbox(UBorder::etchedIn + uheight(40)
	     + uleft()
	     + ugroup(UFont::bold + "Status: \n")
	     + UColor::red + host_stat
	     )
     );

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  cardbox.addlist
    (
     UBgcolor::white + uvmargin(3)
     + new CampusPanel(this)
     + new NetscapePanel(this)
     + new VrengPanel(this)
     + (custom_panel = new CustomPanel(this))
     + new MousePad(this)
     + (macedit = new MacroEditor(this))
     );

  UListbox& cardlist = ulistbox
    (
     UOrient::horizontal +uhspacing(0)
     + uhmargin(1) + uvmargin(1) + uhflex()+ uvflex()
     + UOn::select / ucall(&cardbox, showCard)
     + ubutton(uvmargin(5) + UOn::select/UFont::bold + "Campus")
     + ubutton(UOn::select/UFont::bold + "NScape")
     + ubutton(UOn::select/UFont::bold + "Vreng")
     + ubutton(UOn::select/UFont::bold + "Custom")
     + ubutton(UOn::select/UFont::bold + "MPad")
     );
  cardlist.choice().select(0);

  this->addlist
    (
     UOrient::vertical+ uhflex()
     + uvflex()
     + upane(uvbox( cardlist + uvflex() + cardbox)
	     + host_panel  // par dessus
	     )
     + ubottom()   
     + uhbox(UBgcolor::grey + UBorder::etchedIn
	     + uleft() 
	     + ugroup(UFont::bold + "Host: " )
	     + uhflex() 
	     + utextfield(UColor::navy + host_name
			  + ucall(this, &hlist, &Remote::addHost))
	    + uright() + ubutton("Change" + ushow(&host_panel, true))
	    )
     );
}

/* ==================================================== ======== ======= */

void Remote::addHost(UEvent& e, UListbox* list) {
  if (e.getSource()) {
    host_panel.show(true);
    uptr<UStr> s = ustr(e.getSource()->copyText());
    list->add(uitem(*s));
    list->choice().select(-1);
    host_spane.setYScroll(100.);
  }
}

void Remote::setHost(UEvent&,UListbox* list) {
  host_stat = "";
  UBox* item = list->choice().getItem();
  int index   = list->choice().getIndex();
  if (!item) return;

  // collates the text enclosed in 'item' and copies it to 's'
  UStr selected_name = item->copyText();

  // combler les trous
  if (index >= (int)ums_clients.size()) ums_clients.resize(index+1);
  
  if (index < 0) {    // cas ou la liste est vide
    // impossible: always 1 item in the list
    add(uitem(host_name));
    return;
  }

  //if (index == 0) {  // CP du 1er elt (lie au textfield host_name)
  //  if (ums_clients[0]) delete ums_clients[0];
  //  ums_clients[0] = null;
  //}

  if (!ums_clients[index]) {
    if (selected_name.empty()) {
      host_stat = "No hostname";
      return;
    }

    host_stat = "Contacting " & selected_name & " ...";
    update(UUpdate::paint);  // forcer mise a jour

    ums_clients[index] = UAppli::openUMS(selected_name);
    //cerr << "status: " << ums_clients[index]  << endl;
  }

  if (ums_clients[index]) {
    client = ums_clients[index];
    host_name = selected_name;
    host_stat = "Connected to " & selected_name;
    host_panel.show(false);
  }
  else {
    host_stat = "Can't connect to " & selected_name;
  }
}

void Remote::sendMsg(UStr* target, const char* action) {
  if (client)
    client->sendMessage(target->chars(), action);
}

void Remote::sendBoxMsg(UEvent& e, UStr* target, const char* action) {
  if (client && e.getSource()) { 
    // collates the text enclosed in the source and copies it to 's'
    UStr s =  e.getSource()->copyText();
    //cerr << "send: " << target->chars() << " " << action << s << endl;
    client->sendMessage(target->chars(), action & s);
  }
}

void Remote::sendClick(UStr* target, WinPos* pos) {
  if (client) 
    client->sendMouseClick(target->chars(), pos->x, pos->y, UEvent::MButton1);
}

void Remote::sendPress(UStr* target, WinPos* pos) {
  if (client) 
    client->sendMousePress(target->chars(), pos->x, pos->y, UEvent::MButton1);
}

void Remote::sendRelease(UStr* target, WinPos* pos) {
  if (client) 
    client->sendMouseRelease(target->chars(), pos->x, pos->y, UEvent::MButton1);
}

void Remote::editPos(UEvent& e, WinPos* pos) {
  if (e.getButtons() != UEvent::MButton3) return;
  cerr << "editPos" << endl;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

CampusPanel::CampusPanel(Remote* rem) /*: remote(*rem)*/ {

  UCombobox& commands =
  ucombobox(ulistbox().addItems(targets),
            ucall(&target, copyBoxText));   // UOn::action/ is the default
  target = targets[0];

  UCombobox& doc_box =
    ucombobox(ulistbox().addItems(UPix::doc, Remote::default_files),
              ucall(rem, &target, "file:", &Remote::sendBoxMsg));

  UListbox& hlist = ulistbox();
  if (rem->hosts.size() > 0) hlist.addItems(rem->hosts);
  else hlist.addItems(rem->default_hosts);

  UCombobox& host_box =
    ucombobox(hlist, ucall(rem, &target, "clone:", &Remote::sendBoxMsg));
    
  UBox& part1 = uvbox
    (
     uvflex() + uhflex() + uvspacing(3)
     + ubar(UBgcolor::grey + "Appli:" + uhflex() + commands)
     + ubar(UBgcolor::grey + "Open:" + uhflex() + doc_box)
     + ubar(UBgcolor::grey + "Clone:" + uhflex() + host_box)
     );

  UBox& part2 = uhbox
    (
     uhflex() + uvflex()
     + uhspacing(7)
     + UFont::large
     + ubutton(uhcenter() + " Ctrl ")
     + ubutton(uhcenter() + " Alt  ")
     + ubutton(uhcenter() + " Shft ")
     );

  UBox& part3 = uhbox
    (
     uhcenter() + uvcenter()
     + uscale(ARROW_SCALE)
     + uitem(uhcenter() + USymbol::left
             + ucall(rem, &target, "previous:", &Remote::sendMsg))
     + "  "
     + uvbox(uhcenter() + uvcenter()
             + uitem(uhcenter() + USymbol::up
                     + ucall(rem, &target, "parent:", &Remote::sendMsg))
             +  "  "
             + uitem(uhcenter() + USymbol::down
                     + ucall(rem, &target, "open:", &Remote::sendMsg))
             )
     + "  "
     + uitem(uhcenter() + USymbol::right +
             ucall(rem, &target, "next:", &Remote::sendMsg))
     );
  
  addlist
    (
     uhmargin(5) + uvmargin(2) + uvspacing(3) + UFont::small
     + uvflex()
     + part1
     + part2
     + part3
   );
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

NetscapePanel::NetscapePanel(Remote* rem)/* : remote(*rem)*/ {

  UCombobox& commands =
  ucombobox(ulistbox().addItems(targets),
            ucall(&target, copyBoxText));    
  target = targets[0];

  UCombobox& doc_box =
    ucombobox(ulistbox().addItems(UPix::doc, Remote::default_files),
              ucall(rem, &target, "file:", &Remote::sendBoxMsg));
  
  UBox& part1 = uvbox
    (
     uvflex() + uhflex()+ uvspacing(3)
     + ubar(UBgcolor::grey + "Appli:" + uhflex() + commands)
     + ubar(UBgcolor::grey + "Open:" + uhflex() + doc_box)
     );
  
  UBox& part2 = uhbox
    (
     uhspacing(15) + uhcenter() + uvcenter()
     + ubutton(uhcenter() + " Reload"
               + ucall(rem, &target, &prof.reload, &Remote::sendClick)
               + UOn::mpress / ucall(rem, &prof.reload, &Remote::editPos)
               )
     + ubutton(uhcenter() + " Stop  "
               + ucall(rem, &target, &prof.stop, &Remote::sendClick)
               + UOn::mpress / ucall(rem, &prof.stop, &Remote::editPos)
               )
     );
  
  UBox& part3 = uhbox
    (
     uhflex() + uvflex() + uhspacing(7)
     + UFont::large
     + ubutton(uhcenter() + " Back  "
               + ucall(rem, &target, &prof.back, &Remote::sendClick)
               + UOn::mpress / ucall(rem, &prof.back, &Remote::editPos)
               )
     + ubutton(uhcenter() + " Home  "
               + ucall(rem, &target, &prof.home, &Remote::sendClick)
               + UOn::mpress / ucall(rem, &prof.home, &Remote::editPos)
               )
     + ubutton( uhcenter() + "Forward"
                + ucall(rem, &target, &prof.forward, &Remote::sendClick)
                + UOn::mpress / ucall(rem, &prof.forward, &Remote::editPos)
                )
     );
  
  UBox& part4 = uhbox
    (
     uhcenter() + uvcenter()
     + uscale(ARROW_SCALE)
     + uitem(uhcenter() + USymbol::left
             + ucall(rem, &target, &prof.previous, &Remote::sendClick)
             + UOn::mpress / ucall(rem, &prof.previous, &Remote::editPos)
             )
     + "   "
     + uitem(uhcenter() + USymbol::up
             + ucall(rem, &target, &prof.top, &Remote::sendClick)
             + UOn::mpress / ucall(rem, &prof.top, &Remote::editPos)
             )
     + "   "
     + uitem(uhcenter() + USymbol::right
             + ucall(rem, &target, &prof.next, &Remote::sendClick)
             + UOn::mpress / ucall(rem, &prof.next, &Remote::editPos)
             )
     );

  addlist
    (
     uhmargin(5) + uvmargin(2) + uvspacing(5) + UFont::small
     + uvflex()
     + part1
     + part2
     + part3
     + " " 
     + part4
     );
}
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

VrengPanel::VrengPanel(Remote* rem) /*: remote(*rem)*/ {

  UCombobox& commands =
  ucombobox(ulistbox().addItems(targets),
            ucall(&target, copyBoxText));
  target = targets[0];

  UCombobox& scene_box =
    ucombobox(ulistbox().addItems(UPix::doc, Remote::default_scenes),
              ucall(rem, &target, "file:", &Remote::sendBoxMsg));

 UCombobox& url_box =
   ucombobox(ulistbox().addItems(UPix::doc, Remote::default_urls),
	     ucall(rem, &target, "put:", &Remote::sendBoxMsg));

  UBox& part1 = uvbox
    (
     uhflex() + uvflex() + uvspacing(3)
     //+ UFont::small
     + ubar(UBgcolor::grey + "Appli:" + uhflex() + commands)
     + ubar(UBgcolor::grey + "World:" + uhflex() + scene_box)
     + ubar(UBgcolor::grey + "Put:   " + uhflex() + url_box)
     );

  UBox& part2 = uhbox
    (
     uhflex() + uvflex()
     + uhspacing(3)
     + ubutton(uhcenter() + " Back  "
               + ucall(rem, &target, "back:", &Remote::sendMsg))
     + ubutton(uhcenter() + "Forward"
               + ucall(rem, &target, "forward:", &Remote::sendMsg))
     + ubutton(uhcenter() + " Home  "
               + ucall(rem, &target, "home:", &Remote::sendMsg))
     + ubutton(uhcenter() + " Enter  "
               + ucall(rem, &target, "enter:", &Remote::sendMsg))
     );

  UBox& part3 = uhbox
    (
     uhcenter() + uvcenter()

     // left column
     + uvbox(uhcenter() + uvflex()
	     + ubutton(uscale(2) + uhcenter()+ uvcenter() + UPix::uparrow
		     + UOn::mpress / ucall(rem, &target, "move:up 1", &Remote::sendMsg)
		     + UOn::mrelease / ucall(rem, &target, "move:up 0", &Remote::sendMsg)
		     )
	     + uitem(uscale(ARROW_SCALE) + uhcenter() + USymbol::left
		     + UOn::mpress / ucall(rem, &target, "turn:left 1", &Remote::sendMsg)
		     + UOn::mrelease / ucall(rem, &target, "turn:left 0", &Remote::sendMsg)
		     )
	     + ubutton(uscale(2) + uhcenter()+ uvcenter() + UPix::leftarrow
		     + UOn::mpress / ucall(rem, &target, "move:left 1", &Remote::sendMsg)
		     + UOn::mrelease / ucall(rem, &target, "move:left 0", &Remote::sendMsg)
		     )
	     )

     // middle column
     + uvbox(uhcenter() + uvflex()
	     + uscale(ARROW_SCALE)
             + uitem(uhcenter() + USymbol::up
                     + UOn::mpress / ucall(rem, &target, "move:forward 1", &Remote::sendMsg)
                     + UOn::mrelease / ucall(rem, &target, "move:forward 0", &Remote::sendMsg)
                     )     
             +  "  "
             + uitem(uhcenter() + USymbol::down
                     + UOn::mpress / ucall(rem, &target, "move:backward 1", &Remote::sendMsg)
                     + UOn::mrelease / ucall(rem, &target, "move:backward 0", &Remote::sendMsg)
                     )
             )

     // right column
     + uvbox(uhcenter() + uvflex()
	     + ubutton(uscale(2) + uhcenter() + uvcenter()+ UPix::downarrow
		     + UOn::mpress / ucall(rem, &target, "get:", &Remote::sendMsg)
		     )
	     + uitem(uscale(ARROW_SCALE) + uhcenter() + USymbol::right
		     + UOn::mpress / ucall(rem, &target, "turn:right 1", &Remote::sendMsg)
		     + UOn::mrelease / ucall(rem, &target, "turn:right 0", &Remote::sendMsg)
		     )
	     + ubutton(uscale(2) + uhcenter() + uvcenter()+ UPix::rightarrow
		     + UOn::mpress / ucall(rem, &target, "move:right 1", &Remote::sendMsg)
		     + UOn::mrelease / ucall(rem, &target, "move:right 0", &Remote::sendMsg)
		     )
	     )
     );

  addlist
    (
     uhmargin(5) + uvmargin(2) + uvspacing(3) + UFont::small
     + uvflex()
     + part1
     + part2
     + part3
     );
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

CustomPanel::CustomPanel(Remote* rem) : remote(*rem) {
  addlist
  (
   uhmargin(7) + uvmargin(7) + uvspacing(10)
   + uhbox(uhcenter() + UFont::bold + UFont::large + "Custom commands")
   + uvflex()
   + ubar(UOrient::vertical + UBgcolor::grey
          + uhflex() + uvflex()
          + uscrollpane(macro_list)
          )
   + ubottom()
   + uhbox(uhcenter() + UFont::bold
           + ubutton(" New  "+ ucall(this, &CustomPanel::createMacro))
           + " " + ubutton(" Edit "+ ucall(this, &CustomPanel::editMacro))
           + " " + ubutton("Delete"+ ucall(this, &CustomPanel::deleteMacro))
           )
   );
 }

void CustomPanel::createMacro() {
  remote.macedit->open(this, null);
}

void CustomPanel::editMacro() {
  UGroup* item = macro_list.choice().getItem();
  MacroItem* mac = (item ? dynamic_cast<MacroItem*>(item) : null);
  if (mac) remote.macedit->open(this, mac);
}

void CustomPanel::deleteMacro() {
  UGroup* item = macro_list.choice().getItem();
  MacroItem* mac = (item ? dynamic_cast<MacroItem*>(item) : null);
  if (mac) {
    // pour eviter deletion immediate (et plantage...)
    static uptr<UGroup> tmp;
    tmp = mac;
    macro_list.remove(mac, true);
  }
}

/* ==================================================== ======== ======= */

Macro::Macro() {
  command_type = MClick;
}

MacroItem::MacroItem(const Macro& m, CustomPanel* cpanel) : Macro(m) {
  addlist
    (
     USymbol::right + " "
     + name
     + ucall(this, &(cpanel->remote), &Macro::send)
     );
}

MacroItem& MacroItem::operator=(const Macro& m) {
  command_type = m.command_type;
  name = m.name;
  target = m.target;
  mesg = m.mesg;
  xpos = m.xpos;
  ypos = m.ypos;
   return *this;
}

void Macro::send(Remote*rem) {
  if (target.empty()) {
    cerr << "no window specified" << endl;
    return;
  }
  
  if (command_type == MClick) {
    WinPos pos;
    pos.x = xpos.getValue();
    pos.y = ypos.getValue();
    rem->sendClick(&target, &pos);
  }
  else if (command_type == Message) {
    rem->sendMsg(&target, mesg.chars());
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void MacroEditor::open(UBox* panel, MacroItem* _mac) {
  opening_panel = panel;
  edited_mac = _mac;
  showCard(&remote.cardbox, this);
  if (_mac) {
    title = "Edit Command";
    mac = *_mac;
  }
  else {
    title = "New Command";
    mac_no++;
    mac.name = UStr("command ") & UIntg(mac_no);
  }
}

void MacroEditor::ok() {
  showCard(&remote.cardbox, &opening_panel);
  
  if (opening_panel == remote.custom_panel) {
    if (edited_mac) {
      *edited_mac = mac;
      remote.custom_panel->macro_list.choice().setItem(edited_mac);
      //remote.custom_panel->macro_list.update();
    }
    else {
      MacroItem* m = new MacroItem(mac, remote.custom_panel);
      remote.custom_panel->macro_list.add(m);
      remote.custom_panel->macro_list.choice().setItem(m);
    }
  }
}

void MacroEditor::cancel() {
  showCard(&remote.cardbox, &opening_panel);
}

MacroEditor::MacroEditor(Remote* rem) : remote(*rem) {
  mac_no = 0;
  URadioSelect& type_sel = uradioSelect();

  UBox& table = ubar
    (
     UOrient::vertical + UBgcolor::grey + uhflex() + uvspacing(5)
     
     + uhbox("Name:  "
             + uhflex() + utextfield(mac.name))

     + uhbox("Target: "
             + uhflex()
             + utextfield(mac.target)
             + uright()
             + ubutton(" Select " + ucall(this, &mac, &MacroEditor::selectTarget))
             )

     + uhbox(
            ucheckbox(" MouseClick" + type_sel + UMode::selected
                       + UOn::select / uassign(&mac.command_type, Macro::MClick))
             + uhflex()
             + " x:" + uspinbox(mac.xpos)
             + " y:" + uspinbox(mac.ypos)
             )

     + uhbox(
            ucheckbox(" Message" + type_sel
                        + UOn::select / uassign(&mac.command_type, Macro::Message))
             + uhflex()
             + utextfield(mac.mesg)
             )
    
     );

  // -------------------------------------------------------------------

  addlist
    (
     uhmargin(1) + uvmargin(7) + uvspacing(10)
     + uhbox( UFont::bold + UFont::large + uhcenter() + title)
     + uvflex() 
     + table
     + "  "
     + uhbox(uhcenter()
             + ubutton(UFont::bold + " Test Command" + ucall(&mac, rem, &Macro::send))
             )
     + " "
     + ubottom()
     + ubar(uhflex()  + uhmargin(4) + uvmargin(8)
            + UFont::bold + UBgcolor::grey
            + ubutton("Save " + ucall(this, &MacroEditor::ok))
            + ubutton("Cancel" + ucall(this, &MacroEditor::cancel))
            )
     );
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void toInt(UEvent& e, int* val) {
  UStr s = e.getSource()->copyText();
  if (!s.empty()) *val = atoi(s.c_str());
}

void toFloat(UEvent& e, float* val) {
  UStr s = e.getSource()->copyText();
  if (!s.empty()) *val = atof(s.c_str());
}

/* ==================================================== ======== ======= */

MousePad::MousePad(Remote* _remote) : remote(*_remote) {
  UBox& mouse_buttons = uhbox
    (
     UFont::bold + uhflex()
     + ubutton(" MB1 " 
	       + UOn::mpress   
	       / ucall(this, UEvent::MButton1, &MousePad::pressMouse)
	       + UOn::mrelease 
	       / ucall(this, UEvent::MButton1, &MousePad::releaseMouse)
	       )
     + ubutton(" MB2 " 
	       + UOn::mpress   
	       / ucall(this, UEvent::MButton2, &MousePad::pressMouse)
	       + UOn::mrelease 
	       / ucall(this, UEvent::MButton2, &MousePad::releaseMouse)
	       )
     + ubutton(" MB3 " 
	       + UOn::mpress   
	       / ucall(this, UEvent::MButton3, &MousePad::pressMouse)
	       + UOn::mrelease 
	       / ucall(this, UEvent::MButton3, &MousePad::releaseMouse)
	       )
     + ubutton(" MB4 " 
	       + UOn::mpress   
	       / ucall(this, UEvent::MButton4, &MousePad::pressMouse)
	       + UOn::mrelease 
	       / ucall(this, UEvent::MButton4, &MousePad::releaseMouse)
	       )
     + ubutton(" MB5 " 
	       + UOn::mpress   
	       / ucall(this, UEvent::MButton5, &MousePad::pressMouse)
	       + UOn::mrelease 
	       / ucall(this, UEvent::MButton5, &MousePad::releaseMouse)
	       )
     );

  // -------------------------------------------------------------------

  const char* ptr_values[] = {" 0 ", " 1 ", " 2 ", " 3 ", " 4 ", " 5 ", null};
  const char* mag_values[] = {" 1 ", " 2 ", " 3 ", " 4 ", " 5 ", " 6 ", null};

  /*
  UListbox& ptr_list =
    ulistbox(UOrient::horizontal + ucall(&ptr_no, toInt))
    .addItems(ptr_values);
  ptr_list.choice().setIndex(2);
   */
  UCombobox& ptr_list = ucombobox(ulistbox().addItems(ptr_values),
                                  ucall(&ptr_no, toInt));
  ptr_list.choice().setIndex(1);

  UCombobox& mag_list = ucombobox(ulistbox().addItems(mag_values),
                                  ucall(&mag_factor, toFloat));
  mag_list.choice().setIndex(2);

  UBox& options = ulabel
    (
     uhcenter() + UBgcolor::lightgrey
     + "Pointer: " + ptr_list
     + "  Mag: "   + mag_list
     //+ uspinbox(mag_factor)
     );
  
  // -------------------------------------------------------------------

  this->addlist
    (
     uhflex()
     + utop()
     + uhbox(UFont::bold + UFont::large + uhcenter() + uvmargin(5)
             + " Mouse Control ")
     + options
     + uvflex() 
     + ubox(UBgcolor::white //UBorder::etchedIn
	    + UOn::mmove    / ucall(this, &MousePad::moveMouse)
	    + UOn::mpress   / ucall(this, (u_id)0, &MousePad::pressMouse)
	    + UOn::mrelease / ucall(this, (u_id)0, &MousePad::releaseMouse)
	    + uhcenter() + uvcenter()
            + ulabel(UMode::ignoreEvents + UFont::italic
                     + "Move or drag the mouse in this area")
            )
     + ubottom() 
     + mouse_buttons
     );
}

/* ==================================================== ======== ======= */

void MousePad::pressMouse(UEvent& e, u_id mbutton) {
  if (mbutton == 0) mbutton = e.getButtons();
  //int pno = ptr_list.choice().getIndex()-1;
  if (remote.client) remote.client->pressMouse(ptr_no, mbutton);
}

void MousePad::releaseMouse(UEvent& e, u_id mbutton) {
  if (mbutton == 0) mbutton = e.getButtons();
  //int pno = ptr_list.choice().getIndex()-1;
  if (remote.client) remote.client->releaseMouse(ptr_no, mbutton);
}

void MousePad::moveMouse(UEvent& e) {
  u_pos x = (u_pos)(e.getX() * mag_factor); //.getValue();
  u_pos y = (u_pos)(e.getY() * mag_factor); //.getValue();
  //  int pno = ptr_list.choice().getIndex()-1;
  if (remote.client) remote.client->moveMouse(ptr_no, x, y, true);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

Window grabMouseAndSelect(UAppli*, int& rx, int& ry, int& wx, int& wy);

void MacroEditor::selectTarget(Macro* macro) {
  int rx, ry, wx, wy;
  Window w = grabMouseAndSelect(UAppli::getApp(), rx, ry, wx, wy);
  if (w != None) {
    char buf[20];
    sprintf(buf, "0x%lx", (long)w);
    macro->target.set(buf);
    macro->xpos = wx;
    macro->ypos = wy;
  }
}

Window grabMouseAndSelect(UAppli* app, int& rx, int& ry, int& wx, int& wy) {
  Window w = None;
  rx = ry = wx = wy = 0;

  UNatDisp* nd = app->getNatDisp();
  Display* disp = nd->getXDisplay();
  Window root = nd->getXRootWindow();

  static Cursor cursor = None;
  if (cursor == None) cursor = XCreateFontCursor(disp, XC_crosshair);

  if (XGrabPointer(disp, root,
		   False,
		   ButtonPressMask|ButtonReleaseMask, GrabModeSync,
		   GrabModeAsync, None, cursor, CurrentTime)
      != GrabSuccess) {
    cerr << "Can't grab the mouse\n";
    return None;
  }

  while (true) {
    XEvent ev;    /* get next event */
    XAllowEvents(disp, SyncPointer, CurrentTime);
    XNextEvent(disp, &ev);

    if (ev.type == ButtonPress) {
      // NB: ev.xbutton.(sub)window ne pointent pas sur la fenetre
      // que l'on veut (ni ne retournent les coords ad hoc)

      w = XmuClientWindow(disp, ev.xbutton.subwindow);
      // fprintf(stderr, "cli win: %ld %lx \n", w, w);

      rx = ev.xbutton.x_root;
      ry = ev.xbutton.y_root;

      Window win_child;
      XTranslateCoordinates(disp, /*src*/root, /*dst*/w,
			    rx, ry, &wx, &wy, &win_child);

      //cerr << rx << "  " << ry << " / " << wx << "  " << wy << endl<< endl;
      break;			/* exits loop */
    }
    // else XtDispatchEvent(&ev);
  }

  XUngrabPointer(disp, CurrentTime);      /* Release Grab */
  return w;
}
