#!/usr/bin/env python
# Copyright (C) 2007-2009 Canonical, Ltd.
# Author: Kees Cook <kees@ubuntu.com>
#         Jamie Strandboge <jamie@canonical.com>
# License: GPLv3
import os, sys, tempfile, time, shutil, urllib2, launchpadlib
from launchpadlib.launchpad import Launchpad
from launchpadlib.uris import EDGE_SERVICE_ROOT, LPNET_SERVICE_ROOT
from launchpadlib.credentials import Credentials
from launchpadlib.errors import HTTPError
from launchpadbugs import http_connection

version_min = [1,5,7]
if [int(x) for x in launchpadlib.__version__.split('.')] < version_min:
    raise ValueError, "Requires launchpadlib version %s or later (%s in use)" \
        % (".".join(version_min), launchpadlib.__version__)

def connect(use_edge=True, beta=False):
    cachedir = os.path.expanduser('~/.launchpadlib/cache')
    if not os.path.exists(cachedir):
        os.makedirs(cachedir,0700)

    version="1.0"
    if beta:
        version="beta"

    if use_edge:
        root = EDGE_SERVICE_ROOT
        credfile = os.path.expanduser('~/.launchpadlib/credentials')
    else:
        root = LPNET_SERVICE_ROOT
        credfile = os.path.expanduser('~/.launchpadlib/credentials-lpnet')
    try:
        credentials = Credentials()
        credentials.load(open(credfile))
        launchpad = Launchpad(credentials, root, cachedir, version=version)
    except:
        launchpad = Launchpad.get_token_and_login(sys.argv[0], root, cachedir, version=version)
        credfd = tempfile.NamedTemporaryFile(dir=os.path.dirname(credfile))
        launchpad.credentials.save(credfd)
        os.link(credfd.name, credfile)
        credfd.close()
    return launchpad

def save(item):
    # attempt to deal with intermittent failures
    count = 0
    max_tries = 10
    result = False
    err_str = ""
    while not result and count < max_tries:
        try:
            item.lp_save()
            result = True
        except HTTPError, error:
            err_str = "save() failed: %s" % (error.content)
            count += 1
            time.sleep(5)

    if not result:
        print >>sys.stderr, "%s (tried %d times)" % (err_str, max_tries)
    return result

def extract_task(task):
    name = task.bug_target_name.lower()
    package = None
    distribution = None
    series = None
    if ' (' in name:
        package, distribution = name.split(' (',1)
        distribution = distribution.split(')')[0]
    else:
        package = name
    if distribution and ' ' in distribution:
        distribution, series = distribution.split(' ',1)

    return package, distribution, series

def split_ppa(group):
    if '/' in group:
        group, ppa = group.split('/',1)
    else:
        ppa = 'ppa'
    return group, ppa

def get_archive(name, lp, verbose=False, distribution=None):
    if name == 'ubuntu':
        if verbose:
            print "Loading Ubuntu Archive ..."
        archive, partner = distribution.archives
        group = 'ubuntu'
        ppa = None
    else:
        group, ppa = split_ppa(name)
        if verbose:
            print "Loading %s '%s' PPA ..." % (group, ppa)
        archive = lp.people[group].getPPAByName(name=ppa)
    return archive, group, ppa

def opener_with_cookie(cookie_file):
    # Cookie for protected file downloads
    cookie_processor = http_connection.LPCookieProcessor()
    # Work around Firefox 3.5's dumb sqlite locking problems by copying cookies out:
    sql = None
    if cookie_file.endswith('.sqlite'):
        (cookie_path, cookie_name) = os.path.split(cookie_file)
        sql = tempfile.NamedTemporaryFile(prefix='cookies-XXXXXX', suffix='.sqlite', dir=cookie_path)
        shutil.copy(cookie_file, sql.name)
        cookie_file = sql.name
    cookie_processor.load_file(cookie_file)
    opener = urllib2.build_opener(cookie_processor)
    sql = None
    return opener
